/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.statistics;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.AbstractOptionPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.event.ChartOptionChanged;
import com.pmease.quickbuild.util.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.Radio;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class OneMetricPanel
extends AbstractOptionPanel {
    private static final long serialVersionUID = 1L;

    public OneMetricPanel(String id, StatisticsPanel parentPanel) {
        super(id, parentPanel);
    }

    @Override
    protected Form createForm(String id) {
        return new ComparisonForm(id);
    }

    protected List<Pair<StatisticsItem, StatisticsItem>> getFieldsList() {
        ArrayList result = Lists.newArrayList();
        List<StatisticsItem> items = this.parentPanel.getRenderer().getItems();
        for (int i = 0; i < items.size() / 2 + 1; ++i) {
            StatisticsItem first = i * 2 < items.size() ? items.get(i * 2) : null;
            StatisticsItem second = i * 2 + 1 < items.size() ? items.get(i * 2 + 1) : null;
            Pair pair = new Pair((Object)first, second);
            result.add(pair);
        }
        return result;
    }

    private class ComparisonForm
    extends Form {
        private static final long serialVersionUID = 1L;

        public ComparisonForm(String id) {
            super(id);
            RadioGroup fieldsGroup = new RadioGroup("primaryGroup", (IModel)Model.of((Serializable)OneMetricPanel.this.parentPanel.getChartOption().getPrimaryItem()));
            this.add(new Component[]{fieldsGroup});
            ListView fieldsView = new ListView("primaryFieldsList", OneMetricPanel.this.getFieldsList()){
                private static final long serialVersionUID = 1L;

                protected void populateItem(ListItem item) {
                    Pair pair = (Pair)item.getModelObject();
                    StatisticsItem first = (StatisticsItem)pair.getFirst();
                    StatisticsItem second = (StatisticsItem)pair.getSecond();
                    if (first != null) {
                        item.add(new Component[]{ComparisonForm.this.createRadio("rendererFieldFirst", first)});
                        item.add(new Component[]{new Label("rendererFieldNameFirst", first.getTitle())});
                    } else {
                        item.add(new Component[]{new WebMarkupContainer("rendererFieldFirst").setVisible(false)});
                        item.add(new Component[]{new WebMarkupContainer("rendererFieldNameFirst").setVisible(false)});
                    }
                    if (second != null) {
                        item.add(new Component[]{ComparisonForm.this.createRadio("rendererFieldSecond", second)});
                        item.add(new Component[]{new Label("rendererFieldNameSecond", second.getTitle())});
                    } else {
                        item.add(new Component[]{new WebMarkupContainer("rendererFieldSecond").setVisible(false)});
                        item.add(new Component[]{new WebMarkupContainer("rendererFieldNameSecond").setVisible(false)});
                    }
                }
            };
            fieldsGroup.add(new Component[]{fieldsView});
        }

        protected Radio createRadio(String id, final StatisticsItem item) {
            Radio radio = new Radio(id, (IModel)Model.of((Serializable)item));
            radio.add(new Behavior[]{new AjaxEventBehavior("onclick"){
                private static final long serialVersionUID = 1L;

                protected void onEvent(AjaxRequestTarget target) {
                    OneMetricPanel.this.parentPanel.getChartOption().setPrimaryItem(item);
                    ComparisonForm.this.send((IEventSink)OneMetricPanel.this.parentPanel, Broadcast.BREADTH, new ChartOptionChanged(target));
                }
            }});
            return radio;
        }
    }
}

