/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.statistics;

import com.pmease.quickbuild.plugin.report.engine.renderer.chart.line.LineChart;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.AbstractStatisticsPanel;
import com.pmease.quickbuild.plugin.report.engine.web.event.AjaxEvent;
import com.pmease.quickbuild.web.chart.JFreeChartPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.jfree.chart.JFreeChart;

public class LineChartPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    final AbstractStatisticsPanel parentPanel;

    public LineChartPanel(String id, AbstractStatisticsPanel parentPanel) {
        super(id);
        this.parentPanel = parentPanel;
    }

    public void onInitialize() {
        super.onInitialize();
        Component widthSpan = new WebMarkupContainer("widthSpan").setOutputMarkupId(true);
        if (this.parentPanel.chartWidth > 0) {
            this.add(new Component[]{new JFreeChartPanel("chart", this.parentPanel.chartWidth, this.getHeight(), (IModel)new AbstractReadOnlyModel<JFreeChart>(){
                private static final long serialVersionUID = 1L;

                public JFreeChart getObject() {
                    LineChart lineChart = LineChartPanel.this.parentPanel.getLineChart();
                    if (lineChart != null) {
                        return lineChart.getChart();
                    }
                    return null;
                }
            })});
        } else {
            widthSpan.add(new Behavior[]{new AbstractDefaultAjaxBehavior(){
                private static final long serialVersionUID = 1L;

                protected CharSequence getCallbackScript() {
                    return this.generateCallbackScript("wicketAjaxGet('" + this.getCallbackUrl() + "&ChartWidth=' + chartwidth");
                }

                public void renderHead(Component component, IHeaderResponse response) {
                    super.renderHead(component, response);
                    response.renderOnLoadJavaScript(this.getWidthScript());
                }

                private String getWidthScript() {
                    StringBuffer script = new StringBuffer();
                    script.append("var chartwidth = $('#").append(this.getComponent().getMarkupId()).append("').width();");
                    script.append(this.getCallbackScript());
                    return script.toString();
                }

                protected void respond(AjaxRequestTarget target) {
                    int width = RequestCycle.get().getRequest().getQueryParameters().getParameterValue("ChartWidth").toInt(750);
                    JFreeChartPanel c = new JFreeChartPanel("chart", width, LineChartPanel.this.getHeight(), (IModel)new AbstractReadOnlyModel<JFreeChart>(){
                        private static final long serialVersionUID = 1L;

                        public JFreeChart getObject() {
                            LineChart lineChart = LineChartPanel.this.parentPanel.getLineChart();
                            if (lineChart != null) {
                                return lineChart.getChart();
                            }
                            return null;
                        }
                    });
                    LineChartPanel.this.replace(c.setOutputMarkupId(true));
                    target.add(new Component[]{c});
                }
            }});
            this.add(new Component[]{new WebMarkupContainer("chart").setOutputMarkupId(true)});
        }
        this.add(new Component[]{widthSpan});
    }

    protected int getWidth() {
        int width = this.parentPanel.getChartOption().getWidth();
        if (width <= 0) {
            return 750;
        }
        return width;
    }

    protected int getHeight() {
        int height = this.parentPanel.getChartOption().getHeight();
        if (height <= 0) {
            return 135;
        }
        return height;
    }

    public void onEvent(IEvent<?> sink) {
        if (sink.getPayload() instanceof AjaxEvent) {
            this.onEvent((AjaxEvent)sink.getPayload());
        }
    }

    public void onEvent(AjaxEvent event) {
        if (this.parentPanel.chartWidth > 0) {
            event.getTarget().add(new Component[]{this});
        } else {
            event.getTarget().add(new Component[]{this.get("widthSpan")});
        }
    }
}

