/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.statistics;

import com.pmease.quickbuild.plugin.report.engine.renderer.CompareOption;
import com.pmease.quickbuild.plugin.report.engine.renderer.GroupOption;
import com.pmease.quickbuild.plugin.report.engine.renderer.chart.line.LineChart;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.CompareOtherConfigurationPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.CompareOtherMetricsPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.OneMetricPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.event.ChartOptionChanged;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.event.CompareOptionChanged;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.event.GroupOptionChanged;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.engine.web.event.AjaxEvent;
import com.pmease.quickbuild.plugin.report.engine.web.event.DateRangeChanged;
import com.pmease.quickbuild.plugin.report.engine.web.jquery.JQueryLinkDecorator;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class GraphControls
extends Panel {
    private static final long serialVersionUID = 1L;
    private final StatisticsPanel parentPanel;

    public GraphControls(String id, StatisticsPanel panel) {
        super(id);
        this.parentPanel = panel;
        this.add(new Component[]{new Label("graphOptionLabel", (IModel)new AbstractReadOnlyModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                LineChart lineChart = GraphControls.this.parentPanel.getLineChart();
                if (lineChart == null) {
                    return ReportUtils.cropText(GraphControls.this.parentPanel.getPrimaryItem().getTitle(), 48, 1);
                }
                return ReportUtils.cropText(lineChart.getChartSeries().get(0).getSetting().getTitle(), 18, 1);
            }
        }).setOutputMarkupId(true)});
        this.add(new Component[]{this.createGraphLegends()});
        this.add(new Component[]{this.createGroupOptions()});
        this.add(new Component[]{this.createCompareOptions()});
        this.add(new Component[]{this.createCompareForm()});
    }

    protected Component createCompareForm() {
        switch (this.parentPanel.getChartOption().getCompareOption()) {
            case ONE_METRIC: {
                return new OneMetricPanel("compareOptionForm", this.parentPanel).setOutputMarkupId(true);
            }
            case OTHER_METRICS: {
                return new CompareOtherMetricsPanel("compareOptionForm", this.parentPanel).setOutputMarkupId(true);
            }
            case OTHER_CONFIGURATION: {
                return new CompareOtherConfigurationPanel("compareOptionForm", this.parentPanel).setOutputMarkupId(true);
            }
        }
        return new Label("compareOptionForm", "N/A").setOutputMarkupId(true);
    }

    protected Component createGraphLegends() {
        WebMarkupContainer legendsContainer = new WebMarkupContainer("legendsContainer");
        legendsContainer.setOutputMarkupId(true);
        AbstractReadOnlyModel<List<String>> legendModel = new AbstractReadOnlyModel<List<String>>(){
            private static final long serialVersionUID = 1L;

            public List<String> getObject() {
                return GraphControls.this.parentPanel.getLegends();
            }
        };
        ListView<String> legendLabels = new ListView<String>("legendLabels", (IModel)legendModel){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<String> item) {
                String legend = (String)item.getModelObject();
                item.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)("line_" + item.getIndex()))), " ")});
                item.add(new Component[]{new Label("legendLabel", legend)});
            }
        };
        legendsContainer.add(new Component[]{legendLabels});
        return legendsContainer;
    }

    protected Component createGroupOptions() {
        WebMarkupContainer container = new WebMarkupContainer("groupOptionsContainer");
        container.setOutputMarkupId(true);
        ListView<GroupOption> groupOptions = new ListView<GroupOption>("groupOptions", this.parentPanel.getGroupOptions()){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<GroupOption> item) {
                GroupOption option = (GroupOption)((Object)item.getModelObject());
                item.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)option.name().toLowerCase())), " ")});
                item.add(new Component[]{new GroupOptionLink("groupOption", option)});
            }
        };
        container.add(new Component[]{groupOptions});
        return container;
    }

    protected Component createCompareOptions() {
        List<CompareOption> options = this.parentPanel.getCompareOptions();
        ListView<CompareOption> compareOptions = new ListView<CompareOption>("compareOptions", options){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<CompareOption> item) {
                CompareOption option = (CompareOption)((Object)item.getModelObject());
                item.add(new Component[]{new CompareOptionLink("optionLink", option)});
                item.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)option.name().toLowerCase())), " ")});
            }
        };
        return compareOptions;
    }

    private void onAjaxEvent(AjaxRequestTarget target) {
        target.add(new Component[]{this.get("legendsContainer")});
        target.add(new Component[]{this.get("groupOptionsContainer")});
        target.add(new Component[]{this.get("graphOptionLabel")});
    }

    public void onEvent(IEvent<?> sink) {
        AjaxEvent ae;
        if (sink.getPayload() instanceof AjaxEvent && ((ae = (AjaxEvent)sink.getPayload()) instanceof CompareOptionChanged || ae instanceof GroupOptionChanged || ae instanceof ChartOptionChanged)) {
            this.onAjaxEvent(ae.getTarget());
        }
    }

    public void onEvent(CompareOptionChanged event) {
        this.onAjaxEvent(event.getTarget());
    }

    public void onEvent(GroupOptionChanged event) {
        this.onAjaxEvent(event.getTarget());
    }

    public void onEvent(ChartOptionChanged event) {
        this.onAjaxEvent(event.getTarget());
    }

    public void onEvent(DateRangeChanged event) {
        this.onAjaxEvent(event.getTarget());
    }

    private class CompareOptionLink
    extends AjaxLink {
        private static final long serialVersionUID = 1L;
        private final CompareOption option;

        public CompareOptionLink(String id, CompareOption option) {
            super(id);
            this.option = option;
            this.add(new Component[]{new Label("optionName", GraphControls.this.parentPanel.getCompareOptionLabel(option))});
        }

        public void onClick(AjaxRequestTarget target) {
            if (this.option != GraphControls.this.parentPanel.getChartOption().getCompareOption()) {
                GraphControls.this.parentPanel.getChartOption().setCompareOption(this.option);
                if (GraphControls.this.parentPanel.getChartOption().getCompareOption() != CompareOption.ONE_METRIC) {
                    GraphControls.this.parentPanel.getChartOption().setCompareToPast(false);
                }
                Component comparingForm = GraphControls.this.createCompareForm();
                GraphControls.this.addOrReplace(new Component[]{comparingForm});
                target.add(new Component[]{comparingForm});
                this.send((IEventSink)GraphControls.this.parentPanel, Broadcast.BREADTH, new CompareOptionChanged(target));
            }
        }

        protected void onComponentTag(ComponentTag tag) {
            super.onComponentTag(tag);
            String cssClass = "";
            if (GraphControls.this.parentPanel.getChartOption().getCompareOption() == this.option) {
                cssClass = cssClass + " selected";
            }
            tag.put("class", (CharSequence)cssClass);
        }

        protected IAjaxCallDecorator getAjaxCallDecorator() {
            String decorator = "$('td.graph_mode > a').removeClass('selected'); $(this).addClass('selected'); ";
            return new JQueryLinkDecorator(decorator);
        }
    }

    private class GroupOptionLink
    extends AjaxLink {
        private static final long serialVersionUID = 1L;
        private final GroupOption option;

        public GroupOptionLink(String id, GroupOption option) {
            super(id);
            this.option = option;
            this.add(new Component[]{new Label("optionLabel", "")});
        }

        public void onClick(AjaxRequestTarget target) {
            if (GraphControls.this.parentPanel.isByVersionDisabled() && this.option == GroupOption.BY_VERSION) {
                return;
            }
            if (this.option == GraphControls.this.parentPanel.getChartOption().getGroupOption()) {
                return;
            }
            GraphControls.this.parentPanel.getChartOption().setGroupOption(this.option);
            this.send((IEventSink)GraphControls.this.parentPanel, Broadcast.BREADTH, new GroupOptionChanged(target));
        }

        protected void onComponentTag(ComponentTag tag) {
            super.onComponentTag(tag);
            String cssClass = "";
            if (GraphControls.this.parentPanel.getChartOption().getGroupOption() == this.option) {
                cssClass = "selected";
            }
            if (GraphControls.this.parentPanel.isByVersionDisabled() && this.option == GroupOption.BY_VERSION) {
                cssClass = cssClass + " disabled";
            }
            tag.put("class", (CharSequence)cssClass);
            String title = this.option.getOptionName();
            tag.put("title", (CharSequence)title);
        }

        protected IAjaxCallDecorator getAjaxCallDecorator() {
            String decorator = "if ($(this).hasClass('disabled')) return false; $('.group_option > a').removeClass('selected'); $(this).addClass('selected');";
            return new JQueryLinkDecorator(decorator);
        }
    }
}

