/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.statistics;

import com.pmease.quickbuild.plugin.report.engine.renderer.CompareOption;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.event.CompareOptionChanged;
import com.pmease.quickbuild.plugin.report.engine.web.event.DateRangeChanged;
import com.pmease.quickbuild.util.DateRange;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.PropertyEditor;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;

public class DateRangeFormPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private final StatisticsPanel parentPanel;

    public DateRangeFormPanel(String id, StatisticsPanel parentPanel) {
        super(id);
        this.parentPanel = parentPanel;
        this.setOutputMarkupId(true);
        this.add(new Component[]{new DateRangeForm("dateRangeForm")});
    }

    public void onEvent(CompareOptionChanged event) {
        event.getTarget().add(new Component[]{this});
    }

    public void onEvent(IEvent<?> sink) {
        if (sink.getPayload() instanceof CompareOptionChanged) {
            ((CompareOptionChanged)sink.getPayload()).getTarget().add(new Component[]{this});
        }
    }

    class DateRangeForm
    extends Form {
        private static final long serialVersionUID = 1L;
        private String feedbackMsg;
        private DateRange primaryDateRange;
        private DateRange comparisonDateRange;

        public DateRangeForm(String id) {
            super(id);
            this.primaryDateRange = DateRangeFormPanel.this.parentPanel.getChartOption().getPrimaryDateRange();
            this.comparisonDateRange = DateRangeFormPanel.this.parentPanel.getChartOption().getComparisonDateRange();
            final EditContext primaryRangeContext = new EditContext((Object)this.primaryDateRange);
            final EditContext comparisonRangeContext = new EditContext((Object)this.comparisonDateRange);
            this.add(new Component[]{new PropertyEditor("primaryFromDate", primaryRangeContext.getBeanClass(), primaryRangeContext.getProperty("beginDate"))});
            this.add(new Component[]{new PropertyEditor("primaryToDate", primaryRangeContext.getBeanClass(), primaryRangeContext.getProperty("endDate"))});
            WebMarkupContainer comparePastContainer = new WebMarkupContainer("comparePastContainer"){
                private static final long serialVersionUID = 1L;

                protected void onConfigure() {
                    super.onConfigure();
                    boolean b = DateRangeFormPanel.this.parentPanel.getChartOption().getCompareOption() == CompareOption.ONE_METRIC || DateRangeFormPanel.this.parentPanel.getChartOption().isCompareToPast();
                    this.setVisibilityAllowed(b);
                }
            };
            comparePastContainer.setOutputMarkupId(true);
            this.add(new Component[]{comparePastContainer});
            CheckBox ckComparePast = new CheckBox("ckComparePast", (IModel)new PropertyModel((Object)DateRangeFormPanel.this.parentPanel, "chartOption.compareToPast"));
            comparePastContainer.add(new Component[]{ckComparePast});
            ckComparePast.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onclick"){
                private static final long serialVersionUID = 1L;

                protected void onUpdate(AjaxRequestTarget target) {
                    target.add(new Component[]{DateRangeForm.this.get("comparisonDateRange")});
                }
            }});
            WebMarkupContainer comparisonContainer = new WebMarkupContainer("comparisonDateRange"){
                private static final long serialVersionUID = 1L;

                protected void onConfigure() {
                    super.onConfigure();
                    this.setVisible(((DateRangeFormPanel)DateRangeFormPanel.this).parentPanel.chartOption.isCompareToPast());
                }
            };
            this.add(new Component[]{comparisonContainer});
            comparisonContainer.setOutputMarkupId(true);
            comparisonContainer.setOutputMarkupPlaceholderTag(true);
            comparisonContainer.add(new Component[]{new PropertyEditor("comparisonFromDate", comparisonRangeContext.getBeanClass(), comparisonRangeContext.getProperty("beginDate"))});
            comparisonContainer.add(new Component[]{new PropertyEditor("comparsionToDate", comparisonRangeContext.getBeanClass(), comparisonRangeContext.getProperty("endDate"))});
            final Label feedback = new Label("feedback", (IModel)new AbstractReadOnlyModel<String>(){
                private static final long serialVersionUID = 1L;

                public String getObject() {
                    return DateRangeForm.this.feedbackMsg;
                }
            }){
                private static final long serialVersionUID = 1L;

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    if (!StringUtils.isBlank((String)DateRangeForm.this.feedbackMsg)) {
                        tag.put("style", (CharSequence)"");
                    } else {
                        tag.put("style", (CharSequence)"display:none;");
                    }
                }
            };
            feedback.setEscapeModelStrings(false);
            this.add(new Component[]{feedback.setOutputMarkupId(true)});
            this.add(new Component[]{new AjaxButton("submit"){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target, Form form) {
                    primaryRangeContext.validate(false);
                    if (primaryRangeContext.hasError()) {
                        DateRangeForm.this.feedbackMsg = primaryRangeContext.getError();
                        target.add(new Component[]{feedback});
                        return;
                    }
                    primaryRangeContext.update((Object)DateRangeForm.this.primaryDateRange);
                    if (DateRangeFormPanel.this.parentPanel.getChartOption().isCompareToPast()) {
                        comparisonRangeContext.validate(false);
                        if (comparisonRangeContext.hasError()) {
                            DateRangeForm.this.feedbackMsg = comparisonRangeContext.getError();
                            target.add(new Component[]{feedback});
                            return;
                        }
                        comparisonRangeContext.update((Object)DateRangeForm.this.comparisonDateRange);
                    }
                    DateRangeForm.this.feedbackMsg = DateRangeForm.this.validateDate(DateRangeForm.this.primaryDateRange, DateRangeForm.this.comparisonDateRange);
                    target.add(new Component[]{feedback});
                    if (!StringUtils.isBlank((String)DateRangeForm.this.feedbackMsg)) {
                        return;
                    }
                    if (StringUtils.isBlank((String)DateRangeForm.this.feedbackMsg)) {
                        DateRangeFormPanel.this.parentPanel.getChartOption().setPrimaryDateRange(DateRangeForm.this.primaryDateRange);
                        DateRangeFormPanel.this.parentPanel.getChartOption().setComparisonDateRange(DateRangeForm.this.comparisonDateRange);
                        this.send((IEventSink)DateRangeFormPanel.this.parentPanel, Broadcast.BREADTH, new DateRangeChanged(target, null));
                    }
                }

                protected void onError(AjaxRequestTarget target, Form<?> form) {
                }
            }});
        }

        private String validateDate(DateRange primaryRange, DateRange comparisonRange) {
            String result;
            StringBuilder msg = new StringBuilder();
            String error = this.validateDateRange(primaryRange);
            if (error != null) {
                msg.append("<li>" + error + "</li>");
            }
            if (DateRangeFormPanel.this.parentPanel.getChartOption().isCompareToPast() && (error = this.validateDateRange(comparisonRange)) != null) {
                msg.append("<li>" + error + "</li>");
            }
            if (StringUtils.isEmpty((String)(result = msg.toString()))) {
                return null;
            }
            return "<ul>" + result + "</ul>";
        }

        private String validateDateRange(DateRange dateRange) {
            if (!dateRange.isValid()) {
                return "From Date can't be after To Date.";
            }
            if (dateRange.getEndDate().after(new Date())) {
                return "End Date can't be set after today";
            }
            return null;
        }

        public String getFeedbackMsg() {
            return this.feedbackMsg;
        }

        public void setFeedbackMsg(String feedbackMsg) {
            this.feedbackMsg = feedbackMsg;
        }

        public DateRange getPrimaryDateRange() {
            return this.primaryDateRange;
        }

        public void setPrimaryDateRange(DateRange primaryDateRange) {
            this.primaryDateRange = primaryDateRange;
        }

        public DateRange getComparisonDateRange() {
            return this.comparisonDateRange;
        }

        public void setComparisonDateRange(DateRange comparisonDateRange) {
            this.comparisonDateRange = comparisonDateRange;
        }
    }
}

