/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.statistics;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.AbstractOptionPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.event.ChartOptionChanged;
import com.pmease.quickbuild.plugin.report.engine.web.jquery.JQueryLinkDecorator;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Check;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;

public class CompareOtherMetricsPanel
extends AbstractOptionPanel {
    private static final long serialVersionUID = 1L;

    public CompareOtherMetricsPanel(String id, StatisticsPanel parentPanel) {
        super(id, parentPanel);
    }

    protected ListView<StatisticsItem> createFieldsListView(String id, boolean isFirst) {
        return new ListView<StatisticsItem>(id, this.getFields(isFirst)){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<StatisticsItem> item) {
                Check check = new Check("rendererField", item.getModel());
                StatisticsItem field = (StatisticsItem)item.getModelObject();
                item.add(new Component[]{check});
                item.add(new Component[]{new Label("fieldName", field.getTitle())});
            }
        };
    }

    protected List<StatisticsItem> getFields(boolean isFirst) {
        List<StatisticsItem> items = this.parentPanel.getComparableFields();
        ArrayList<StatisticsItem> result = new ArrayList<StatisticsItem>();
        for (int i = 0; i < items.size(); ++i) {
            boolean accept;
            boolean bl = accept = isFirst && i % 2 == 0 || !isFirst && i % 2 != 0;
            if (!accept) continue;
            result.add(items.get(i));
        }
        return result;
    }

    public void onEvent(ChartOptionChanged event) {
        event.getTarget().add(new Component[]{this});
    }

    @Override
    protected Form createForm(String id) {
        return new ComparisonForm(id);
    }

    private class ComparisonForm
    extends Form {
        private static final long serialVersionUID = 1L;
        private List<StatisticsItem> fields;

        public ComparisonForm(String id) {
            super(id);
            this.fields = Lists.newArrayList();
            this.fields = CompareOtherMetricsPanel.this.parentPanel.getComparisonItems();
            CheckGroup checkGroup = new CheckGroup("fieldsGroup", (IModel)new PropertyModel((Object)this, "fields"));
            checkGroup.setRenderBodyOnly(false);
            this.add(new Component[]{checkGroup.setOutputMarkupId(true)});
            checkGroup.add(new Component[]{CompareOtherMetricsPanel.this.createFieldsListView("firstFieldsList", true)});
            checkGroup.add(new Component[]{CompareOtherMetricsPanel.this.createFieldsListView("secondFieldsList", false)});
            AjaxButton submitBtn = new AjaxButton("submit"){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                    if (ComparisonForm.this.fields.size() > 3) {
                        ComparisonForm.this.fields = new ArrayList(ComparisonForm.this.fields.subList(0, 3));
                    }
                    target.add(new Component[]{form.get("fieldsGroup")});
                    CompareOtherMetricsPanel.this.parentPanel.getChartOption().setComparisonItems(ComparisonForm.this.fields);
                    this.send((IEventSink)CompareOtherMetricsPanel.this.parentPanel, Broadcast.BREADTH, new ChartOptionChanged(target));
                }

                protected IAjaxCallDecorator getAjaxCallDecorator() {
                    String decorator = "$('#graph_form').hide(); $('#graphTabOptions').removeClass('current');";
                    return new JQueryLinkDecorator(decorator);
                }

                protected void onError(AjaxRequestTarget target, Form<?> form) {
                }
            };
            this.add(new Component[]{submitBtn});
            this.setDefaultButton((IFormSubmittingComponent)submitBtn);
        }
    }
}

