/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.statistics;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.AbstractOptionPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.event.ChartOptionChanged;
import com.pmease.quickbuild.plugin.report.engine.web.jquery.JQueryLinkDecorator;
import com.pmease.quickbuild.web.component.editor.ConfigurationPathEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.form.Form;

public class CompareOtherConfigurationPanel
extends AbstractOptionPanel {
    private static final long serialVersionUID = 1L;
    private static final int MAX_CONFIGS = 3;

    public CompareOtherConfigurationPanel(String id, StatisticsPanel panel) {
        super(id, panel);
    }

    public void onEvent(IEvent<?> sink) {
        if (sink.getPayload() instanceof ChartOptionChanged) {
            ((ChartOptionChanged)sink.getPayload()).getTarget().add(new Component[]{this});
        }
    }

    @Override
    protected Form createForm(String id) {
        return new ComparisonForm(id);
    }

    public static class ConfigurationBean {
        private Configuration configuration;

        public ConfigurationBean() {
        }

        public ConfigurationBean(Configuration config) {
            this.configuration = config;
        }

        @Editable
        public Configuration getConfiguration() {
            return this.configuration;
        }

        public void setConfiguration(Configuration configuration) {
            this.configuration = configuration;
        }
    }

    private class ComparisonForm
    extends Form {
        private static final long serialVersionUID = 1L;

        public ComparisonForm(String id) {
            super(id);
            List<Long> configs = CompareOtherConfigurationPanel.this.parentPanel.getComparisonConfigs();
            Configuration[] configurations = new Configuration[3];
            for (int i = 0; i < configs.size(); ++i) {
                Long config = configs.get(i);
                configurations[i] = (Configuration)((ConfigurationManager)Quickbuild.getInstance(ConfigurationManager.class)).get(config);
            }
            final EditContext[] contexts = new EditContext[3];
            for (int i = 0; i < 3; ++i) {
                contexts[i] = new EditContext((Object)new ConfigurationBean(configurations[i]));
                this.add(new Component[]{new ConfigurationPathEditor("configChooser" + i, contexts[i].getBeanClass(), contexts[i].getProperty("configuration"))});
            }
            this.add(new Component[]{new AjaxButton("submit"){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                    boolean hasError = false;
                    CompareOtherConfigurationPanel.this.parentPanel.getChartOption().getComparisonConfigs().clear();
                    for (int i = 0; i < 3; ++i) {
                        EditContext context = contexts[i];
                        context.validate(false);
                        if (context.hasError()) {
                            hasError = true;
                            continue;
                        }
                        ConfigurationBean bean = new ConfigurationBean();
                        context.update((Object)bean);
                        Configuration configuration = bean.getConfiguration();
                        if (configuration == null) continue;
                        CompareOtherConfigurationPanel.this.parentPanel.getChartOption().getComparisonConfigs().add(configuration.getId());
                    }
                    if (!hasError) {
                        this.send((IEventSink)CompareOtherConfigurationPanel.this.parentPanel, Broadcast.BREADTH, new ChartOptionChanged(target));
                    } else {
                        target.add(new Component[]{CompareOtherConfigurationPanel.this});
                    }
                }

                protected IAjaxCallDecorator getAjaxCallDecorator() {
                    String decorator = "$('#graph_form').hide(); $('#graphTabOptions').removeClass('current');";
                    return new JQueryLinkDecorator(decorator);
                }

                protected void onError(AjaxRequestTarget target, Form<?> form) {
                }
            }});
        }
    }
}

