/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.statistics;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Restrictions;
import com.pmease.quickbuild.plugin.report.engine.datatype.BooleanType;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.datatype.EnumType;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.CompareOption;
import com.pmease.quickbuild.plugin.report.engine.renderer.GroupOption;
import com.pmease.quickbuild.plugin.report.engine.renderer.LineChartOption;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.SessionData;
import com.pmease.quickbuild.plugin.report.engine.renderer.chart.line.LineChart;
import com.pmease.quickbuild.plugin.report.engine.renderer.chart.line.LineChartData;
import com.pmease.quickbuild.plugin.report.engine.renderer.chart.line.LineChartSetting;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsRenderer;
import com.pmease.quickbuild.plugin.report.engine.util.BuildFragment;
import com.pmease.quickbuild.plugin.report.engine.util.Builds;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.util.DateRange;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.ajax.IAjaxIndicatorAware;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class AbstractStatisticsPanel
extends Panel
implements IAjaxIndicatorAware {
    private static final long serialVersionUID = 1L;
    protected final StatisticsRenderer renderer;
    protected final LineChartOption chartOption;
    private final IModel<LineChart> chartModel;
    private String reportset;
    int chartWidth = -1;

    public AbstractStatisticsPanel(String id, StatisticsRenderer renderer, IModel<RendererContext> model) {
        super(id, model);
        this.renderer = renderer;
        RendererContext context = (RendererContext)model.getObject();
        LineChartOption option = context.getLineChartOption();
        this.chartOption = option == null ? SessionData.get().getLineChartOption() : option;
        this.validateChartOption();
        this.setOutputMarkupId(true);
        this.chartModel = new LoadableDetachableModel<LineChart>(){
            private static final long serialVersionUID = 1L;

            protected LineChart load() {
                return AbstractStatisticsPanel.this.loadLineChart();
            }
        };
    }

    protected void validateChartOption() {
        DateRange dateRange;
        List<StatisticsItem> comparisonItems;
        StatisticsItem primaryItem = this.chartOption.getPrimaryItem();
        List<StatisticsItem> availables = this.renderer.getItems();
        if (!this.isRenderable(primaryItem)) {
            this.chartOption.setPrimaryItem(availables.get(0));
        }
        if ((comparisonItems = this.chartOption.getComparisonItems()) != null) {
            Iterator<StatisticsItem> it = comparisonItems.iterator();
            while (it.hasNext()) {
                StatisticsItem each = it.next();
                if (this.isRenderable(each)) continue;
                it.remove();
            }
        }
        if (this.isByVersionDisabled() && this.chartOption.getGroupOption() == GroupOption.BY_VERSION) {
            this.chartOption.setGroupOption(GroupOption.BY_DAY);
        }
        if ((dateRange = this.chartOption.getPrimaryDateRange()) == null || !dateRange.isValid()) {
            this.chartOption.setPrimaryDateRange(new DateRange());
        }
        SessionData.get().setLineChartOption(this.chartOption);
    }

    protected boolean isRenderable(StatisticsItem item) {
        return item != null && this.renderer.hasItem(item);
    }

    public LineChart getLineChart() {
        return (LineChart)this.chartModel.getObject();
    }

    protected LineChart loadLineChart() {
        long start = System.currentTimeMillis();
        ArrayList series = Lists.newArrayList();
        StatisticsItem primaryItem = this.getPrimaryItem();
        Builds builds = this.getBuilds(this.getConfiguration().getId(), this.chartOption.getPrimaryDateRange());
        LineChartData data = this.loadChartData(this.getConfiguration().getId(), primaryItem, builds, this.chartOption.getPrimaryDateRange());
        series.add(data);
        if (this.isCompareToPast()) {
            Builds past = this.getBuilds(this.getConfiguration().getId(), this.chartOption.getComparisonDateRange());
            data = this.loadChartData(this.getConfiguration().getId(), primaryItem, past, this.chartOption.getComparisonDateRange());
            series.add(data);
        } else {
            switch (this.chartOption.getCompareOption()) {
                case ONE_METRIC: {
                    break;
                }
                case OTHER_METRICS: {
                    List<StatisticsItem> comparisonItems = this.chartOption.getComparisonItems();
                    for (StatisticsItem each : comparisonItems) {
                        if (Objects.equal((Object)each, (Object)primaryItem)) continue;
                        data = this.loadChartData(this.getConfiguration().getId(), each, builds, this.chartOption.getPrimaryDateRange());
                        series.add(data);
                    }
                    break;
                }
                case OTHER_CONFIGURATION: {
                    List<Long> comparisonIds = this.chartOption.getComparisonConfigs();
                    for (Long each : comparisonIds) {
                        if (Objects.equal((Object)each, (Object)this.getConfiguration().getId())) continue;
                        Builds comparisonBuilds = this.getBuilds(each, this.chartOption.getPrimaryDateRange());
                        data = this.loadChartData(each, primaryItem, comparisonBuilds, this.chartOption.getPrimaryDateRange());
                        series.add(data);
                    }
                    break;
                }
            }
        }
        if (Context.getLogger().isDebugEnabled()) {
            Context.getLogger().debug("Loading line chart in " + DataTypes.DURATION.asString(System.currentTimeMillis() - start));
        }
        return new LineChart(series, this.isShowBuildInfo(), this.chartOption);
    }

    protected boolean isShowReports() {
        return ReportHelper.isShowReports(this.renderer.getCategory());
    }

    protected Builds getBuilds(Long configId, DateRange dateRange) {
        if (!this.isShowReports()) {
            return new Builds();
        }
        return ReportUtils.findBuilds(configId, dateRange, this.chartOption.isExcludingFailed());
    }

    protected LineChartData loadChartData(Long configId, StatisticsItem item, Builds builds, DateRange dateRange) {
        LineChartSetting setting = new LineChartSetting(item);
        setting.setDateRange(dateRange);
        switch (this.chartOption.getCompareOption()) {
            case ONE_METRIC: {
                if (this.isCompareToPast()) {
                    setting.setTitle(dateRange.format("MMM dd"));
                    break;
                }
                setting.setTitle(item.getTitle());
                break;
            }
            case OTHER_METRICS: {
                setting.setTitle(item.getTitle());
                break;
            }
            case OTHER_CONFIGURATION: {
                setting.setTitle(this.getConfiguration(configId).getName());
            }
        }
        LineChartData data = new LineChartData(setting, this.chartOption);
        if (!this.isShowReports()) {
            return data;
        }
        DataReport report = this.loadReport(configId, item, builds);
        if (report != null) {
            data.build(report, builds);
        }
        return data;
    }

    protected DataReport loadReport(Long configId, StatisticsItem item, Builds builds) {
        File dir;
        DataReport report = item.getCategory().createReport(item.getReportName());
        if (builds.isEmpty()) {
            return report;
        }
        ReportCategory category = item.getCategory();
        String reportset = this.getReportSet();
        if (Strings.isNullOrEmpty((String)reportset)) {
            reportset = "DEFAULT";
        }
        if (!(dir = category.getReportDirOfStats(this.getConfiguration(configId), reportset)).exists()) {
            return null;
        }
        BuildFragment from = builds.getFrom();
        BuildFragment to = builds.getTo();
        ArrayList filters = Lists.newArrayList();
        filters.add(Restrictions.and(Restrictions.ge("buildId", from.getId()), Restrictions.le("buildId", to.getId())));
        filters.addAll(this.getFilters(item));
        return category.loadReport(dir, item.getReportName(), (Filter[])Iterables.toArray((Iterable)filters, Filter.class));
    }

    protected List<Filter> getFilters(StatisticsItem item) {
        return Collections.emptyList();
    }

    public String getReportSet() {
        if (this.reportset == null) {
            this.reportset = this.getContext().getReportSet();
        }
        if (this.reportset == null) {
            this.reportset = SessionData.get().getReportSet();
        }
        return this.reportset;
    }

    public void setReportSet(String reportset) {
        this.reportset = reportset;
    }

    public DataColumn statisticsItemToDataColumn(StatisticsItem item) {
        DataType dataType = item.getDataType();
        if (dataType instanceof BooleanType || dataType instanceof EnumType) {
            dataType = DataTypes.PERCENT;
        }
        return new DataColumn(item.getValueExpression(), dataType);
    }

    public StatisticsItem getPrimaryItem() {
        return this.chartOption.getPrimaryItem();
    }

    public LineChartOption getChartOption() {
        return this.chartOption;
    }

    public boolean isByVersionDisabled() {
        StatisticsItem primaryItem = this.getPrimaryItem();
        if (primaryItem.isByVersionDisabled()) {
            return true;
        }
        if (this.chartOption.getCompareOption() == CompareOption.OTHER_METRICS) {
            List<StatisticsItem> comparisonItems = this.chartOption.getComparisonItems();
            for (StatisticsItem each : comparisonItems) {
                if (!each.isByVersionDisabled()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isShowBuildInfo() {
        return true;
    }

    public boolean isCompareToPast() {
        return this.chartOption.getCompareOption() == CompareOption.ONE_METRIC && this.chartOption.isCompareToPast();
    }

    public List<Long> getComparisonConfigs() {
        ArrayList result = Lists.newArrayList(this.getChartOption().getComparisonConfigs());
        Long current = this.getConfiguration().getId();
        Iterator it = result.iterator();
        while (it.hasNext()) {
            Long each = (Long)it.next();
            if (!Objects.equal((Object)each, (Object)current)) continue;
            it.remove();
        }
        return result;
    }

    public List<StatisticsItem> getComparisonItems() {
        ArrayList result = Lists.newArrayList(this.chartOption.getComparisonItems());
        StatisticsItem primaryItem = this.getChartOption().getPrimaryItem();
        List<StatisticsItem> availables = this.renderer.getItems();
        Iterator it = result.iterator();
        while (it.hasNext()) {
            StatisticsItem each = (StatisticsItem)it.next();
            if (!Objects.equal((Object)each, (Object)primaryItem) && availables.contains(each)) continue;
            it.remove();
        }
        return result;
    }

    public String getCompareOptionLabel(CompareOption option) {
        return option.getOptionName();
    }

    public List<GroupOption> getGroupOptions() {
        return Arrays.asList(GroupOption.values());
    }

    public List<CompareOption> getCompareOptions() {
        return Arrays.asList(CompareOption.values());
    }

    public RendererContext getContext() {
        return (RendererContext)this.getDefaultModelObject();
    }

    public Configuration getConfiguration(Long configId) {
        return (Configuration)((ConfigurationManager)Quickbuild.getInstance(ConfigurationManager.class)).get(configId);
    }

    public String[] getReportSets() {
        ReportCategory category = this.renderer.getCategory();
        return category.getReportSetsOfStats(this.getConfiguration());
    }

    protected Configuration getConfiguration() {
        return Context.getConfiguration();
    }

    public StatisticsRenderer getRenderer() {
        return this.renderer;
    }

    public void onDetach() {
        if (this.chartModel != null) {
            this.chartModel.detach();
        }
        super.onDetach();
    }

    public String getAjaxIndicatorMarkupId() {
        return "global-ajax-indicator";
    }
}

