/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.piechart;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.piechart.PieChartDashboardPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.piechart.PieChartItem;
import java.util.List;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.dom4j.Element;

public class PieChartRenderer
extends AbstractRenderer {
    private static final long serialVersionUID = 1L;
    @Alias(name="width")
    private int width = 145;
    @Alias(name="height")
    private int height = 140;
    @Alias(name="withLegend")
    private boolean withLegend = true;
    @Alias(name="noDataMessage")
    private String noDataMessage;
    @Alias
    private boolean calcStats = false;
    @Alias
    private boolean displayTrend = true;
    private List<PieChartItem> items = Lists.newArrayList();

    public PieChartRenderer(ReportCategory category) {
        super(category);
        this.setContentOnly(true);
    }

    @Override
    public String getType() {
        return "PIECHART";
    }

    @Override
    public Panel createReportPanel(String id, IModel<RendererContext> model) {
        return new PieChartDashboardPanel(id, this, model);
    }

    @Override
    public void fromXML(Element node) {
        super.fromXML(node);
        List nodes = node.elements("item");
        for (Element each : nodes) {
            PieChartItem item = new PieChartItem(this);
            item.fromXML(each);
            this.items.add(item);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean isWithLegend() {
        return this.withLegend;
    }

    public void setWithLegend(boolean withLegend) {
        this.withLegend = withLegend;
    }

    public String getNoDataMessage() {
        return this.noDataMessage;
    }

    public void setNoDataMessage(String noDataMessage) {
        this.noDataMessage = noDataMessage;
    }

    public List<PieChartItem> getItems() {
        return this.items;
    }

    public void setItems(List<PieChartItem> items) {
        this.items = items;
    }

    public boolean isCalcStats() {
        return this.calcStats;
    }

    public void setCalcStats(boolean calcStats) {
        this.calcStats = calcStats;
    }

    public boolean isDisplayTrend() {
        return this.displayTrend;
    }

    public void setDisplayTrend(boolean displayTrend) {
        this.displayTrend = displayTrend;
    }
}

