/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.piechart;

import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.piechart.PieChartItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.piechart.PieChartRenderer;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class PieChartLegendPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    final PieChartRenderer renderer;

    public PieChartLegendPanel(String id, PieChartRenderer renderer, IModel<ItemContext> model) {
        super(id, model);
        this.renderer = renderer;
    }

    public void onInitialize() {
        super.onInitialize();
        final double totals = this.getTotals();
        this.add(new Component[]{new ListView<PieChartItem>("legends", this.renderer.getItems()){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<PieChartItem> item) {
                PieChartItem each = (PieChartItem)item.getModelObject();
                ItemContext context = PieChartLegendPanel.this.getItemContext();
                String color = each.getColor(context);
                WebMarkupContainer colorContainer = new WebMarkupContainer("legendColor");
                colorContainer.add(new Behavior[]{new AttributeAppender("style", (IModel)Model.of((Serializable)((Object)("background: " + color))), " ")});
                item.add(new Component[]{colorContainer});
                item.add(new Component[]{new Label("legendTitle", each.getTitle())});
                StringBuffer sb = new StringBuffer();
                Number value = (Number)each.getValue(context);
                if (value == null) {
                    value = 0;
                }
                double percent = totals == 0.0 ? 0.0 : value.doubleValue() / totals;
                sb.append(each.getText(context)).append(" (").append(DataTypes.PERCENT.asString(percent, "0%")).append(")");
                item.add(new Component[]{new Label("legendData", sb.toString())});
                item.add(new Component[]{each.createComponent("trendInfo", (IModel<ItemContext>)PieChartLegendPanel.this.getDefaultModel())});
            }
        }});
    }

    protected double getTotals() {
        List<PieChartItem> items = this.renderer.getItems();
        double totals = 0.0;
        ItemContext context = this.getItemContext();
        for (PieChartItem each : items) {
            Double value = (Double)DataTypes.DOUBLE.typeCast(each.getValue(context));
            if (value == null) {
                value = 0.0;
            }
            totals += value.doubleValue();
        }
        return totals;
    }

    protected ItemContext getItemContext() {
        return (ItemContext)this.getDefaultModelObject();
    }
}

