/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.piechart;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.dashboard.AbstractDashboardStatsPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.piechart.PieChartItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.piechart.PieChartLegendPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.piechart.PieChartRenderer;
import com.pmease.quickbuild.web.component.dashboardpanel.PieChartModulePanel;
import com.pmease.quickbuild.web.component.dashboardpanel.StatsData;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class PieChartDashboardPanel
extends AbstractDashboardStatsPanel {
    private static final long serialVersionUID = 1L;

    public PieChartDashboardPanel(String id, PieChartRenderer renderer, IModel<RendererContext> model) {
        super(id, renderer, model);
    }

    @Override
    public void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.createPieChart("pieChart")});
    }

    @Override
    public PieChartRenderer getRenderer() {
        return (PieChartRenderer)super.getRenderer();
    }

    protected Component createPieChart(String id) {
        LoadableDetachableModel<List<StatsData>> dataModel = new LoadableDetachableModel<List<StatsData>>(){
            private static final long serialVersionUID = 1L;

            protected List<StatsData> load() {
                return PieChartDashboardPanel.this.getStatsData();
            }
        };
        PieChartRenderer renderer = this.getRenderer();
        PieChartModulePanel panel = new PieChartModulePanel(id, renderer.getWidth(), renderer.getHeight(), renderer.getNoDataMessage(), renderer.isWithLegend(), (IModel)dataModel){
            private static final long serialVersionUID = 1L;

            protected Component createLegends(String id) {
                return new PieChartLegendPanel(id, PieChartDashboardPanel.this.getRenderer(), (IModel<ItemContext>)PieChartDashboardPanel.this.contextModel);
            }
        };
        panel.setRenderBodyOnly(true);
        return panel;
    }

    protected List<StatsData> getStatsData() {
        ArrayList list = Lists.newArrayList();
        ItemContext context = this.getItemContext();
        for (PieChartItem each : this.getRenderer().getItems()) {
            Object value = each.getValue(context);
            String color = each.getColor(context);
            StatsData data = new StatsData();
            data.setColor(color);
            data.setValue(value);
            data.setTitle(each.getTitle());
            list.add(data);
        }
        return list;
    }
}

