/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.item;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.ReportDataSource;
import com.pmease.quickbuild.plugin.report.engine.datastore.SqlBuilder;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.SessionData;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.AbstractLinkItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.SourceBlockSetting;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.web.page.error.ErrorMessagePage;
import com.pmease.quickbuild.web.page.source.Block;
import com.pmease.quickbuild.web.page.source.SourceViewPage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.link.PopupSettings;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewSourceLinkItem
extends AbstractLinkItem {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ViewSourceLinkItem.class);
    private SourceBlockSetting blockSetting = new SourceBlockSetting(this.getCategory());

    public ViewSourceLinkItem(AbstractRenderer renderer) {
        super(renderer);
    }

    @Override
    public String getType() {
        return "VIEW_SOURCE";
    }

    @Override
    public void fromXML(Element element) {
        super.fromXML(element);
        Element node = (Element)element.selectSingleNode("./block-setting");
        if (node != null) {
            this.blockSetting.fromXML(node);
        }
    }

    @Override
    protected AbstractLink doCreateLink(String id, ItemContext context) {
        ViewSourceLink link = new ViewSourceLink(id, context);
        link.setPopupSettings(new PopupSettings("popup", 12));
        link.setVisible(SecurityHelper.hasPermission((String)ConfigurationPermission.VIEW_SOURCE.name()));
        return link;
    }

    protected Block[] rowsToBlocks(List<DataRow> rows) {
        ArrayList blocks = Lists.newArrayList();
        ScriptEngine em = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
        for (DataRow row : rows) {
            Map<String, Object> c = row.toMap();
            c.put("utils", ReportUtils.getInstance());
            if (this.blocksDefined()) {
                ArrayList tmpBlocks = Lists.newArrayList(this.getLineBlocks(em, c));
                if (!StringUtils.isEmpty((String)this.blockSetting.getColorExpression()) || !StringUtils.isEmpty((String)this.blockSetting.getMessageExpression())) {
                    for (Block block : tmpBlocks) {
                        String message;
                        if (!StringUtils.isEmpty((String)this.blockSetting.getColorExpression())) {
                            String color = (String)em.evaluate(this.blockSetting.getColorExpression(), c);
                            block.setColor(color);
                        }
                        if (StringUtils.isEmpty((String)this.blockSetting.getMessageExpression()) || StringUtils.isEmpty((String)(message = (String)em.evaluate(this.blockSetting.getMessageExpression(), c)))) continue;
                        block.setMessage(message);
                    }
                }
                blocks.addAll(tmpBlocks);
                continue;
            }
            Block block = this.createLineBlock(em, c);
            blocks.add(block);
        }
        return (Block[])Iterables.toArray((Iterable)blocks, Block.class);
    }

    protected SourceViewPage createSourceViewPage(String title, String sourceType, String[] lines, Block[] blocks, int startLine) {
        return new SourceViewPage(title, sourceType, lines, blocks, startLine);
    }

    public boolean blocksDefined() {
        return !StringUtils.isEmpty((String)this.blockSetting.getBlocksExpression());
    }

    protected List<Block> getLineBlocks(ScriptEngine em, Map<String, Object> ec) {
        Object value = em.evaluate(this.blockSetting.getBlocksExpression(), ec);
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof Block) {
            return Arrays.asList((Block)value);
        }
        if (value instanceof List) {
            return (List)value;
        }
        return Collections.emptyList();
    }

    protected Block createLineBlock(ScriptEngine em, Map<String, Object> ec) {
        Integer startLine = 0;
        if (!StringUtils.isEmpty((String)this.blockSetting.getStartLineExpression())) {
            startLine = (Integer)em.evaluate(this.blockSetting.getStartLineExpression(), ec);
        }
        Integer endLine = 0;
        if (!StringUtils.isEmpty((String)this.blockSetting.getEndLineExpression())) {
            endLine = (Integer)em.evaluate(this.blockSetting.getEndLineExpression(), ec);
        }
        String color = null;
        if (this.blockSetting.getColorExpression() != null && this.blockSetting.getColorExpression().charAt(0) == '#') {
            color = this.blockSetting.getColorExpression();
        } else if (!StringUtils.isEmpty((String)this.blockSetting.getColorExpression())) {
            color = (String)em.evaluate(this.blockSetting.getColorExpression(), ec);
        }
        if (!Strings.isNullOrEmpty(color) && color.charAt(0) == '#') {
            color = color.substring(1);
        }
        String message = null;
        if (!StringUtils.isEmpty((String)this.blockSetting.getMessageExpression())) {
            message = (String)em.evaluate(this.blockSetting.getMessageExpression(), ec);
        }
        return new Block(startLine.intValue(), endLine.intValue(), color, message);
    }

    public SourceBlockSetting getBlockSetting() {
        return this.blockSetting;
    }

    public void setBlockSetting(SourceBlockSetting blockSetting) {
        this.blockSetting = blockSetting;
    }

    private class ViewSourceLink
    extends Link<Void> {
        private static final long serialVersionUID = 1L;
        private ItemContext context;

        public ViewSourceLink(String id, ItemContext context) {
            super(id);
            this.context = context;
        }

        public void onClick() {
            this.doViewSource();
        }

        protected void doViewSource() {
            Map<String, Object> ec = ViewSourceLinkItem.this.buildExpressionContext(this.context);
            ScriptEngine em = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
            String fileName = "";
            ec.put("utils", ReportUtils.getInstance());
            fileName = (String)em.evaluate(ViewSourceLinkItem.this.blockSetting.getFileNameExpression(), ec);
            if (logger.isDebugEnabled()) {
                logger.debug("View source file: " + fileName);
            }
            List lines = null;
            Build build = this.context.getBuild();
            lines = build.readSourceFile(fileName);
            if (lines == null) {
                this.setResponsePage((Page)new ErrorMessagePage("Error", "File not found in repository: " + fileName));
                return;
            }
            if (lines.isEmpty()) {
                this.setResponsePage((Page)new ErrorMessagePage("Error", "The lines of source file " + fileName + " is zero."));
                return;
            }
            List<DataRow> rows = null;
            if (ViewSourceLinkItem.this.blockSetting.getDataSource() != null) {
                ReportDataSource dataSource = new ReportDataSource(ViewSourceLinkItem.this.category);
                dataSource.deepCopy(ViewSourceLinkItem.this.blockSetting.getDataSource());
                String currentReportSet = SessionData.get().getReportSet();
                ReportCategory category = ViewSourceLinkItem.this.getCategory();
                File dbDir = category.getReportDirOfBuild(build, currentReportSet);
                SqlBuilder query = dataSource.toQuery(ViewSourceLinkItem.this.buildExpressionContext(this.context));
                DataReport report = category.loadReport(dbDir, query);
                rows = report.getRows();
            } else {
                rows = Arrays.asList(this.context.getDataRow());
            }
            Block[] blocks = ViewSourceLinkItem.this.rowsToBlocks(rows);
            String title = fileName;
            String sourceType = FilenameUtils.getExtension((String)fileName);
            String toLine = ViewSourceLinkItem.this.blockSetting.getToLine();
            int startLine = 0;
            if (!Strings.isNullOrEmpty((String)toLine)) {
                startLine = (Integer)em.evaluate(toLine, ec);
            }
            this.setResponsePage((Page)ViewSourceLinkItem.this.createSourceViewPage(title, sourceType, (String[])Iterables.toArray((Iterable)lines, String.class), blocks, startLine));
        }
    }
}

