/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.item;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.RendererItem;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.velocity.runtime.parser.node.MathUtils;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class TrendItem
extends RendererItem {
    private static final long serialVersionUID = 1L;
    static String UP_TRIANGLE = "\u25b2";
    static String DOWN_TRIANGLE = "\u25bc";
    static String EMPTY_TRIANGLE = "";
    @Alias
    private String upColor;
    @Alias
    private String downColor;
    @Alias
    private String trendColor;

    public TrendItem(AbstractRenderer renderer) {
        super(renderer);
    }

    @Override
    public String getType() {
        return "TREND";
    }

    @Override
    public Component createComponent(String id, IModel<ItemContext> model) {
        return this.createTrendComponent(id, model);
    }

    protected Component createTrendComponent(String id, IModel<ItemContext> model) {
        String css;
        ItemContext context = (ItemContext)model.getObject();
        Trend trend = this.getTrend(context);
        if (trend == Trend.UNKNOWN) {
            return new WebMarkupContainer(id).setVisible(false);
        }
        Label label = new Label(id, trend.getLabel());
        String color = this.getTrendColor(trend, context);
        if (!Strings.isNullOrEmpty((String)color)) {
            label.add(new Behavior[]{new AttributeAppender("style", (IModel)Model.of((Serializable)((Object)("color:" + color))), ";")});
        }
        if ((css = this.getCss()) == null) {
            css = "";
        }
        label.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)("trend-item " + css))), " ")});
        return label;
    }

    protected static Trend calcTrend(Number current, Number previous) {
        double d = current.doubleValue() - previous.doubleValue();
        if (MathUtils.isZero((Number)d)) {
            return Trend.EQUAL;
        }
        if (d > 0.0) {
            return Trend.UP;
        }
        return Trend.DOWN;
    }

    public Trend getTrend(ItemContext context) {
        Trend trend;
        String valueExp = this.getValueExpression();
        DataRow currentRow = context.getDataRow();
        Number current = (Number)currentRow.getValue(valueExp);
        Map<String, Object> previousStats = context.getPrevStats();
        if (previousStats == null || previousStats.isEmpty()) {
            trend = Trend.UNKNOWN;
        } else {
            Number previous = MapUtils.getNumber(previousStats, (Object)valueExp, (Number)0);
            trend = TrendItem.calcTrend(current, previous);
        }
        return trend;
    }

    protected String getTrendColor(Trend trend, ItemContext context) {
        String color = this.getTrendColor();
        if (!Strings.isNullOrEmpty((String)color)) {
            return this.getColor(color, context);
        }
        switch (trend) {
            case UP: {
                return this.getColor(this.getUpColor(), context);
            }
            case DOWN: {
                return this.getColor(this.getDownColor(), context);
            }
        }
        return "#666666";
    }

    protected String getColor(String colorExp, ItemContext context) {
        if (Strings.isNullOrEmpty((String)colorExp)) {
            return "#000000";
        }
        if (colorExp.charAt(0) == '#') {
            return colorExp;
        }
        return (String)ReportHelper.evaluate(colorExp, this.buildExpressionContext(context));
    }

    public String getUpColor() {
        return this.upColor;
    }

    public void setUpColor(String upColor) {
        this.upColor = upColor;
    }

    public String getDownColor() {
        return this.downColor;
    }

    public void setDownColor(String downColor) {
        this.downColor = downColor;
    }

    public String getTrendColor() {
        return this.trendColor;
    }

    public void setTrendColor(String trendColor) {
        this.trendColor = trendColor;
    }

    public static enum Trend {
        EQUAL(""),
        UP(UP_TRIANGLE),
        DOWN(DOWN_TRIANGLE),
        UNKNOWN("");

        final String label;

        private Trend(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

