/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.item;

import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.TextItem;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class TextItemPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    final TextItem item;

    public TextItemPanel(String id, TextItem item, IModel<ItemContext> model) {
        super(id, model);
        this.item = item;
    }

    public void onInitialize() {
        super.onInitialize();
        ItemContext context = this.getContext();
        String text = this.item.getText(context);
        this.add(new Component[]{this.createLabel("prefix", this.item.getPrefix(), this.item.isEscaped()).setRenderBodyOnly(true).setVisible(!StringUtils.isEmpty((String)text))});
        this.add(new Component[]{this.createLabel("suffix", this.item.getSuffix(), this.item.isEscaped()).setRenderBodyOnly(true).setVisible(!StringUtils.isEmpty((String)text))});
        Component c = this.createValueItem("value");
        this.add(new Component[]{c});
    }

    protected ItemContext getContext() {
        return (ItemContext)this.getDefaultModelObject();
    }

    protected Component createValueItem(String id) {
        ItemContext context = this.getContext();
        String text = this.item.getText(context);
        Label label = this.createLabel(id, text, this.item.isEscaped());
        this.afterComponentCreated((Component)label, context, text);
        return label;
    }

    protected void afterComponentCreated(Component label, ItemContext context, String text) {
        String color = this.item.getColor(context);
        if (!StringUtils.isEmpty((String)color)) {
            label.add(new Behavior[]{new AttributeAppender("style", (IModel)Model.of((Serializable)((Object)("color:" + color))), ";")});
        }
        if (!StringUtils.isEmpty((String)this.item.getCss())) {
            label.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)this.item.getCss())), " ")});
        }
        if (this.item.isValueAsCss()) {
            String css = text.toLowerCase().replaceAll(" ", "-");
            label.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)css)), " ")});
        }
        if (!StringUtils.isEmpty((String)this.item.getTooltip())) {
            label.add(new Behavior[]{new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)this.item.getTooltip(context))))});
        }
    }

    protected Label createLabel(String id, String value, boolean escaped) {
        if (StringUtils.isEmpty((String)value)) {
            Label label = new Label(id, "");
            label.setVisible(false);
            return label;
        }
        String text = value;
        int wrapLength = this.item.getWrapLength();
        if (this.item.isMultiline()) {
            text = ReportUtils.wrapAsHtmlMultiline(value, wrapLength);
        } else if (wrapLength > 0) {
            text = ReportUtils.wrapText(value, wrapLength);
        }
        Label label = new Label(id, text);
        if (this.item.isMultiline()) {
            label.setEscapeModelStrings(false);
        } else {
            label.setEscapeModelStrings(escaped);
        }
        return label;
    }

    public TextItem getItem() {
        return this.item;
    }
}

