/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.item;

import com.google.common.base.Strings;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.RendererItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.TextItemPanel;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;

public class TextItem
extends RendererItem {
    private static final long serialVersionUID = 1L;
    @Alias
    private String prefix;
    @Alias
    private String suffix;
    @Alias
    private boolean escaped = true;
    @Alias
    private boolean valueAsCss = false;
    @Alias
    private boolean multiline = false;
    @Alias
    private int wrapLength = 0;
    @Alias(name="text")
    private String textExpression;

    public TextItem(AbstractRenderer renderer) {
        super(renderer);
    }

    @Override
    public String getType() {
        return "TEXT";
    }

    @Override
    public String getText(ItemContext context) {
        if (Strings.isNullOrEmpty((String)this.textExpression)) {
            if (!this.interpolate) {
                return super.getText(context);
            }
            ScriptEngine em = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
            Map<String, Object> ec = this.buildExpressionContext(context);
            return em.interpolate(this.getValueExpression(), ec);
        }
        return this.textExpression;
    }

    @Override
    public Component createComponent(String id, IModel<ItemContext> model) {
        return new TextItemPanel(id, this, model);
    }

    public boolean isEscaped() {
        return this.escaped;
    }

    public void setEscaped(boolean escaped) {
        this.escaped = escaped;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public boolean isValueAsCss() {
        return this.valueAsCss;
    }

    public void setValueAsCss(boolean valueAsCss) {
        this.valueAsCss = valueAsCss;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }

    public int getWrapLength() {
        return this.wrapLength;
    }

    public void setWrapLength(int wrapLength) {
        this.wrapLength = wrapLength;
    }

    public String getTextExpression() {
        return this.textExpression;
    }

    public void setTextExpression(String textExpression) {
        this.textExpression = textExpression;
    }
}

