/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.item;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.plugin.report.engine.metadata.AbstractCategoryItem;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;

public abstract class RendererItem
extends AbstractCategoryItem {
    private static final long serialVersionUID = 1L;
    @Alias(name="value")
    protected String valueExpression;
    @Alias(name="pattern")
    protected String formatPattern;
    @Alias(name="default")
    protected String defaultValue = "";
    @Alias
    protected String tooltip;
    @Alias(name="color")
    protected String colorExpression;
    @Alias
    protected boolean interpolate = false;
    @Alias
    protected String css;
    @Alias
    protected String dataType;
    protected final AbstractRenderer renderer;

    public abstract Component createComponent(String var1, IModel<ItemContext> var2);

    public RendererItem(AbstractRenderer renderer) {
        super(renderer.getCategory());
        this.renderer = renderer;
    }

    @Override
    public String getElementName() {
        return "item";
    }

    public Object getValue(ItemContext context) {
        if (Strings.isNullOrEmpty((String)this.valueExpression)) {
            return null;
        }
        if (this.interpolate) {
            return ReportHelper.interpolate(this.valueExpression, this.buildExpressionContext(context));
        }
        return ReportHelper.evaluate(this.valueExpression, this.buildExpressionContext(context));
    }

    public String getText(ItemContext context) {
        String text;
        Object value = this.getValue(context);
        if (value == null) {
            text = this.defaultValue;
        } else {
            DataRow row = context.getDataRow();
            DataType dataType = !Strings.isNullOrEmpty((String)this.dataType) ? DataTypes.getDataType(this.dataType) : (row.getReport().getMeta().hasColumn(this.valueExpression) ? row.getReport().getDataType(this.valueExpression) : DataTypes.getDataType(value));
            text = Strings.isNullOrEmpty((String)this.formatPattern) ? dataType.asString(value) : (Objects.equal((Object)"RAW", (Object)this.formatPattern) ? dataType.asString(value, null) : dataType.asString(value, this.formatPattern));
        }
        if (Strings.isNullOrEmpty((String)text)) {
            text = this.defaultValue;
        }
        return text;
    }

    public Map<String, Object> buildExpressionContext(ItemContext context) {
        HashMap<String, Object> map = new HashMap<String, Object>(context.getExpressionContext());
        map.put("utils", ReportUtils.getInstance());
        map.put("quickbuild", Quickbuild.getInstance());
        ReportCategory category = this.getCategory();
        map.put("category", category);
        return map;
    }

    public String getTooltip(ItemContext context) {
        if (Strings.isNullOrEmpty((String)this.tooltip)) {
            return null;
        }
        if (this.tooltip.contains("${")) {
            return ReportHelper.interpolate(this.tooltip, this.buildExpressionContext(context));
        }
        return this.tooltip;
    }

    public String getColor(ItemContext context) {
        if (Strings.isNullOrEmpty((String)this.colorExpression)) {
            return null;
        }
        if (this.colorExpression.startsWith("#")) {
            return this.colorExpression;
        }
        Map<String, Object> map = this.buildExpressionContext(context);
        map.put("self", this.getValue(context));
        return (String)ReportHelper.evaluate(this.colorExpression, map);
    }

    public String getValueExpression() {
        return this.valueExpression;
    }

    public void setValueExpression(String valueExpression) {
        this.valueExpression = valueExpression;
    }

    public String getFormatPattern() {
        return this.formatPattern;
    }

    public void setFormatPattern(String formatPattern) {
        this.formatPattern = formatPattern;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public String getColorExpression() {
        return this.colorExpression;
    }

    public void setColorExpression(String colorExpression) {
        this.colorExpression = colorExpression;
    }

    public boolean isInterpolate() {
        return this.interpolate;
    }

    public void setInterpolate(boolean interpolate) {
        this.interpolate = interpolate;
    }

    public String getCss() {
        return this.css;
    }

    public void setCss(String css) {
        this.css = css;
    }

    public AbstractRenderer getRenderer() {
        return this.renderer;
    }
}

