/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.item;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.ReportFilter;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.SessionData;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.FilterLinkItem;
import com.pmease.quickbuild.web.page.build.BuildPage;
import com.pmease.quickbuild.web.page.configuration.StatisticsPage;
import java.io.Serializable;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class RedirectLinkItem
extends FilterLinkItem {
    private static final long serialVersionUID = 1L;
    @Alias
    MainTab mainTab = MainTab.BUILD;
    @Alias(name="to")
    String subTab;

    public RedirectLinkItem(AbstractRenderer renderer) {
        super(renderer);
    }

    @Override
    public String getType() {
        return "REDIRECT_LINK";
    }

    @Override
    protected AbstractLink doCreateLink(String id, final ItemContext context) {
        Link<Void> link = new Link<Void>(id){
            private static final long serialVersionUID = 1L;

            public void onClick() {
                ReportFilter filter = RedirectLinkItem.this.createFilter(context);
                SessionData.get().setFilter(filter);
                SessionData.get().setConfigurationId(RedirectLinkItem.this.getConfigurationId(context));
                SessionData.get().setCategoryId(RedirectLinkItem.this.getCategory().getId());
                SessionData.get().setReportSet(context.getReportSet());
                String reportTab = RedirectLinkItem.this.category.getName().replaceAll(" ", "_").toLowerCase();
                String subTab = !Strings.isNullOrEmpty((String)RedirectLinkItem.this.subTab) ? RedirectLinkItem.this.subTab.replaceAll(" ", "_").toLowerCase() : null;
                if (RedirectLinkItem.this.mainTab == MainTab.BUILD) {
                    PageParameters params = BuildPage.params4((Long)RedirectLinkItem.this.getBuildId(context), (String[])new String[]{reportTab, subTab});
                    this.setResponsePage(BuildPage.class, params);
                } else {
                    PageParameters params = StatisticsPage.params4((Long)RedirectLinkItem.this.getConfigurationId(context), (String[])new String[]{reportTab, subTab});
                    this.setResponsePage(StatisticsPage.class, params);
                }
            }
        };
        link.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)"redirect")), " ")});
        return link;
    }

    protected Long getBuildId(ItemContext context) {
        return context.getBuild().getId();
    }

    protected Long getConfigurationId(ItemContext context) {
        return context.getConfiguration().getId();
    }

    public MainTab getMainTab() {
        return this.mainTab;
    }

    public void setMainTab(MainTab mainTab) {
        this.mainTab = mainTab;
    }

    public String getSubTab() {
        return this.subTab;
    }

    public void setSubTab(String subTab) {
        this.subTab = subTab;
    }

    public String[] getIgnores() {
        return this.ignores;
    }

    public void setIgnores(String[] ignores) {
        this.ignores = ignores;
    }

    public static enum MainTab {
        BUILD,
        STATISTICS;

    }
}

