/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.item;

import com.google.common.base.Preconditions;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.web.ContextAware;
import com.pmease.quickbuild.web.page.BasePage;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;

public abstract class PopupWindow
extends BasePage
implements ContextAware {
    private static final long serialVersionUID = 1L;
    private final String title;
    private final Long buildId;
    private final Long configurationId;

    protected abstract Component renderContent(String var1);

    public PopupWindow(String title, Long buildId, Long configurationId) {
        Preconditions.checkArgument((buildId != null || configurationId != null ? 1 : 0) != 0, (Object)"Either build id or configuration MUST be set for popup window.");
        this.title = title;
        this.buildId = buildId;
        this.configurationId = configurationId;
    }

    public void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.renderContent("content")});
    }

    public String getPageTitle() {
        if (StringUtils.isEmpty((String)this.title)) {
            return super.getPageTitle();
        }
        return this.title;
    }

    protected int getAjaxRefreshInterval() {
        return 0;
    }

    public Build getContext() {
        if (this.buildId != null) {
            return (Build)((BuildManager)Quickbuild.getInstance(BuildManager.class)).get(this.buildId);
        }
        Build build = new Build();
        Configuration configuration = (Configuration)((ConfigurationManager)Quickbuild.getInstance(ConfigurationManager.class)).get(this.configurationId);
        build.setConfiguration(configuration);
        return build;
    }
}

