/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.item;

import com.google.common.base.Strings;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.ReportFilter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.SearchCriterion;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.SimpleFilterDef;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.FilterLinkItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.PopupWindow;
import com.pmease.quickbuild.plugin.report.engine.util.TypedObjects;
import com.pmease.quickbuild.web.component.dialog.Dialog;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.link.PopupSettings;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.dom4j.Element;

public class PopupItem
extends FilterLinkItem {
    private static final long serialVersionUID = 1L;
    @Alias
    private boolean newWindow = false;
    @Alias
    private String title;
    @Alias
    private String dropdownCss;
    @Alias
    private String dialogOptions;
    private AbstractRenderer popupRenderer;

    public PopupItem(AbstractRenderer renderer) {
        super(renderer);
    }

    @Override
    public String getType() {
        return "POPUP";
    }

    protected AbstractLink createPopupWindowLink(String id, final ItemContext context) {
        Link<Void> link = new Link<Void>(id){
            private static final long serialVersionUID = 1L;

            public void onClick() {
                Build build = Context.getBuild();
                Configuration configuration = Context.getConfiguration();
                Long buildId = null;
                if (build != null) {
                    buildId = build.getId();
                }
                Long configurationId = null;
                if (configuration != null) {
                    configurationId = configuration.getId();
                }
                PopupWindow window = new PopupWindow(PopupItem.this.getTitle(context), buildId, configurationId){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected Component renderContent(String id) {
                        return PopupItem.this.createContent(id, context).setRenderBodyOnly(true);
                    }
                };
                this.setResponsePage((Page)window);
            }
        };
        link.setPopupSettings(new PopupSettings("popup", 12));
        return link;
    }

    protected Component createContent(String id, ItemContext context) {
        RendererContext rc = this.createRendererContext(context);
        return this.popupRenderer.createReportPanel(id, (IModel<RendererContext>)Model.of((Serializable)rc));
    }

    protected AbstractLink createPopupDialogLink(String id, final ItemContext context) {
        return new AjaxLink<Void>(id){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                Dialog dialog = new Dialog(PopupItem.this.getTitle(context)){
                    private static final long serialVersionUID = 1L;

                    protected Component render(String id) {
                        return PopupItem.this.createContent(id, context);
                    }
                };
                String dlgcss = "popup-content ";
                if (!Strings.isNullOrEmpty((String)PopupItem.this.getDropdownCss())) {
                    dlgcss = dlgcss + PopupItem.this.getDropdownCss();
                }
                dialog.dialogClass(dlgcss).width(600).options(PopupItem.this.getDialogOptions()).open(target);
            }
        };
    }

    @Override
    protected AbstractLink doCreateLink(String id, ItemContext context) {
        if (this.isNewWindow()) {
            return this.createPopupWindowLink(id, context);
        }
        return this.createPopupDialogLink(id, context);
    }

    protected RendererContext createRendererContext(ItemContext context) {
        RendererContext rc = new RendererContext();
        rc.setReportSet(context.getReportSet());
        HashMap<String, Object> map = new HashMap<String, Object>(context.getExpressionContext());
        rc.setExpressionContext(map);
        List<SimpleFilterDef> filters = this.getFilters();
        ReportFilter filter = new ReportFilter();
        for (SimpleFilterDef each : filters) {
            filter.addSimpleFilter((SearchCriterion)each.toFilter(map));
        }
        rc.setReportFilter(filter);
        return rc;
    }

    public String getTitle(ItemContext context) {
        String title = this.getTitle();
        if (StringUtils.isEmpty((String)title)) {
            title = this.popupRenderer.getTitle();
        }
        title = !StringUtils.isEmpty((String)title) ? ReportHelper.interpolate(title, this.buildExpressionContext(context)) : null;
        return title;
    }

    @Override
    public void fromXML(Element node) {
        super.fromXML(node);
        Element e = node.element("renderer");
        if (e != null) {
            AbstractRenderer popupRenderer = TypedObjects.createTypedObject(e, AbstractRenderer.class, null, this.category);
            popupRenderer.fromXML(e);
            this.setPopupRenderer(popupRenderer);
        }
    }

    public boolean isNewWindow() {
        return this.newWindow;
    }

    public void setNewWindow(boolean newWindow) {
        this.newWindow = newWindow;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public AbstractRenderer getPopupRenderer() {
        return this.popupRenderer;
    }

    public void setPopupRenderer(AbstractRenderer popupRenderer) {
        this.popupRenderer = popupRenderer;
        this.popupRenderer.setParentRenderer(this.getRenderer());
        this.popupRenderer.setInDropDown(true);
    }

    public String getDropdownCss() {
        return this.dropdownCss;
    }

    public void setDropdownCss(String dropdownCss) {
        this.dropdownCss = dropdownCss;
    }

    public String getDialogOptions() {
        return this.dialogOptions;
    }

    public void setDialogOptions(String dialogOptions) {
        this.dialogOptions = dialogOptions;
    }
}

