/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.item;

import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.ImageItemPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.TextItem;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;

public class ImageItem
extends TextItem {
    private static final long serialVersionUID = 1L;
    private static Map<String, String> enumImageMap;
    @Alias(name="imageUrl")
    private String imageUrl;

    public ImageItem(AbstractRenderer renderer) {
        super(renderer);
    }

    public String getImagePath(ItemContext context) {
        String text = this.getText(context);
        if (StringUtils.isEmpty((String)text)) {
            return null;
        }
        if (!StringUtils.isEmpty((String)this.imageUrl)) {
            return text;
        }
        if (enumImageMap.get(text.toLowerCase()) == null) {
            return "/images/report/unknown.png";
        }
        return "/images/report/" + enumImageMap.get(text.toLowerCase());
    }

    @Override
    public String getText(ItemContext context) {
        if (!StringUtils.isEmpty((String)this.imageUrl)) {
            Map<String, Object> map = this.buildExpressionContext(context);
            if (this.imageUrl.charAt(0) == '/') {
                return this.imageUrl;
            }
            return (String)ReportHelper.evaluate(this.imageUrl, map);
        }
        String str = super.getText(context);
        if (StringUtils.isEmpty((String)str)) {
            return "unknown";
        }
        return str;
    }

    @Override
    public Component createComponent(String id, IModel<ItemContext> model) {
        ItemContext context = (ItemContext)model.getObject();
        String text = this.getText(context);
        String imagePath = this.getImagePath(context);
        if (StringUtils.isEmpty((String)imagePath)) {
            return new WebMarkupContainer(id).setVisible(false);
        }
        if (StringUtils.isEmpty((String)this.imageUrl)) {
            return new ImageItemPanel(id, text, imagePath);
        }
        return new ImageItemPanel(id, imagePath);
    }

    @Override
    public String getType() {
        return "IMAGE";
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("unknown", "unknown.png");
        map.put("true", "ok.gif");
        map.put("success", "successful.gif");
        map.put("pass", "ok.gif");
        map.put("passed", "ok.gif");
        map.put("successful", "successful.gif");
        map.put("criticalerror", "criticalerror.gif");
        map.put("criticalwarning", "criticalwarning.gif");
        map.put("error", "error.gif");
        map.put("failed", "error.gif");
        map.put("false", "error.gif");
        map.put("failure", "failure.gif");
        map.put("fail", "warning.gif");
        map.put("skip", "skip.gif");
        map.put("warn", "warning.gif");
        map.put("warning", "warning.gif");
        map.put("info", "info.gif");
        map.put("information", "info.gif");
        map.put("ignore", "ignore.gif");
        map.put("add", "added.gif");
        map.put("modify", "modified.gif");
        map.put("delete", "deleted.gif");
        map.put("priority1", "info.gif");
        map.put("priority2", "info.gif");
        map.put("priority3", "warning.gif");
        map.put("priority4", "warning.gif");
        map.put("priority5", "error.gif");
        map.put("added", "added12x12.gif");
        map.put("fixed", "ok.gif");
        map.put("not_fixed", "notfixed12x12.gif");
        enumImageMap = map;
    }
}

