/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.item;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.ReportDataSource;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.ReportFilter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Restrictions;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.historystats.HistoryStatsRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.DropDownItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsItem;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.dom4j.Element;
import org.dom4j.Node;

public class HistoryStatsItem
extends DropDownItem {
    private static final long serialVersionUID = 1L;
    @Alias(name="report")
    private String reportName;
    @Alias
    private String buildColumn;
    @Alias
    private String title;
    private List<StatisticsItem> items = Lists.newArrayList();

    public HistoryStatsItem(AbstractRenderer renderer) {
        super(renderer);
        this.setImageUrl("report/one-chart.gif");
    }

    @Override
    public String getType() {
        return "HISTORY_STATS";
    }

    @Override
    public void fromXML(Element node) {
        String[] columnNames;
        super.fromXML(node);
        for (String each : columnNames = XMLHelper.getStringArray((Node)node, "valueColumns")) {
            StatisticsItem item = new StatisticsItem(this.category);
            item.setTitle(each);
            item.setValueExpression(each);
            item.setReportName(this.reportName);
            this.items.add(item);
        }
        List elements = node.selectNodes("./valueItem");
        for (Element each : elements) {
            StatisticsItem item = new StatisticsItem(this.category);
            item.setReportName(this.reportName);
            item.fromXML(each);
            this.items.add(item);
        }
    }

    @Override
    public String getText(ItemContext context) {
        return "N/A";
    }

    @Override
    public Component createDropDownContent(String id, IModel<ItemContext> contextModel) {
        ItemContext context = (ItemContext)contextModel.getObject();
        String popupTitle = Strings.isNullOrEmpty((String)this.title) ? "Statistics Info" : ReportHelper.interpolate(this.title, this.buildExpressionContext(context));
        HistoryStatsRenderer popupRenderer = new HistoryStatsRenderer(this.category);
        popupRenderer.setTitle(popupTitle);
        popupRenderer.setBuildColumn(this.buildColumn);
        popupRenderer.setValueItems(this.items);
        popupRenderer.setContentOnly(true);
        popupRenderer.setInDropDown(true);
        ReportDataSource rds = new ReportDataSource(this.category);
        rds.setFrom(this.reportName);
        popupRenderer.setDataSource(rds);
        ReportFilter filter = new ReportFilter();
        ReportDataSource parentrds = this.getRenderer().getDataSource();
        DataRow row = context.getDataRow();
        if (parentrds != null && Objects.equal((Object)this.reportName, (Object)parentrds.getFrom())) {
            filter.addSimpleFilter(Restrictions.idEq(row.getId()));
        } else {
            DataColumn[] primaryColumns;
            for (DataColumn each : primaryColumns = popupRenderer.getMeta().getPrimaryColumns()) {
                filter.addSimpleFilter(Restrictions.eq(each.getColumnName(), row.getNullableValue(each.getColumnName())));
            }
        }
        RendererContext rc = new RendererContext();
        rc.setReportSet(context.getReportSet());
        rc.setReportFilter(filter);
        return popupRenderer.createReportPanel(id, (IModel<RendererContext>)Model.of((Serializable)rc));
    }

    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public String getBuildColumn() {
        return this.buildColumn;
    }

    public void setBuildColumn(String buildColumn) {
        this.buildColumn = buildColumn;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    public List<StatisticsItem> getItems() {
        return this.items;
    }

    public void setItems(List<StatisticsItem> items) {
        this.items = items;
    }
}

