/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.item;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.ReportFilter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Restrictions;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.SimpleExpression;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.SimpleFilterDef;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererMode;
import com.pmease.quickbuild.plugin.report.engine.renderer.SessionData;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.AbstractLinkItem;
import com.pmease.quickbuild.plugin.report.engine.util.TypedObjects;
import com.pmease.quickbuild.plugin.report.engine.web.event.ReportFilterChanged;
import com.pmease.quickbuild.web.page.BasePage;
import com.pmease.quickbuild.web.page.dashboard.DashboardPage;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.dom4j.Element;

public class FilterLinkItem
extends AbstractLinkItem {
    private static final long serialVersionUID = 1L;
    @Alias
    String filterBy;
    @Alias
    String[] ignores = new String[0];
    List<SimpleFilterDef> filters = Lists.newArrayList();

    public FilterLinkItem(AbstractRenderer renderer) {
        super(renderer);
    }

    @Override
    public String getType() {
        return "FILTER_LINK";
    }

    @Override
    protected AbstractLink doCreateLink(String id, final ItemContext context) {
        AjaxLink<Void> link = new AjaxLink<Void>(id){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                if (FilterLinkItem.this.filters.isEmpty()) {
                    return;
                }
                ReportFilter filter = FilterLinkItem.this.createFilter(context);
                this.send((IEventSink)context.getReportPanel(), Broadcast.DEPTH, new ReportFilterChanged(target, filter));
            }

            protected void onConfigure() {
                super.onConfigure();
                if (FilterLinkItem.this.getRenderer().isInDropDown() || FilterLinkItem.this.getRenderer().getMode() == RendererMode.DASHBOARD || BasePage.get() instanceof DashboardPage) {
                    this.setEnabled(false);
                    return;
                }
                this.setEnabled(!FilterLinkItem.this.filterExists());
            }
        };
        link.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)"filter-link")), " ")});
        return link;
    }

    protected ReportFilter createFilter(ItemContext context) {
        ReportFilter old = SessionData.get().getFilter();
        ReportFilter filter = new ReportFilter(old);
        if (this.getRenderer().getMode() == RendererMode.DASHBOARD) {
            filter.clear();
        } else if (this.ignores != null && this.ignores.length > 0) {
            if (ArrayUtils.contains((Object[])this.ignores, (Object)"ALL")) {
                filter.clear();
            } else {
                for (String each : this.ignores) {
                    filter.removeSimpleFilter(each);
                }
            }
        }
        Map<String, Object> map = this.buildExpressionContext(context);
        for (SimpleFilterDef each : this.filters) {
            if (each == null) continue;
            if (each.getColumn().equalsIgnoreCase("id")) {
                filter.clear();
                DataRow row = context.getDataRow();
                filter.addSimpleFilter(Restrictions.idEq(row.getId()));
                return filter;
            }
            Filter f = each.toFilter((Map)map);
            f = each.isNeedEvaluate() ? each.toFilter((Map)map) : each.toFilter((Map)null);
            filter.addSimpleFilter((SimpleExpression)f);
        }
        return filter;
    }

    protected boolean filterExists() {
        ReportFilter reportFilter = SessionData.get().getFilter();
        if (reportFilter == null) {
            return false;
        }
        if (reportFilter.contains("id")) {
            return true;
        }
        Set<String> names = reportFilter.getSimpleColumnNames();
        boolean exists = false;
        for (SimpleFilterDef each : this.filters) {
            if (!each.isNeedEvaluate()) continue;
            if (!names.contains(each.getColumn())) {
                return false;
            }
            exists = true;
        }
        return exists;
    }

    @Override
    public void fromXML(Element node) {
        super.fromXML(node);
        if (!Strings.isNullOrEmpty((String)this.filterBy)) {
            this.setFilterBy(this.filterBy);
        }
        List nodes = node.elements("filter");
        for (Element each : nodes) {
            SimpleFilterDef f = TypedObjects.createTypedObject(each, SimpleFilterDef.class, new SimpleFilterDef(), new Object[0]);
            f.fromXML(each);
            this.filters.add(f);
        }
    }

    public String getFilterBy() {
        return this.filterBy;
    }

    public void setFilterBy(String filterBy) {
        this.filterBy = filterBy;
        for (String column : Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)filterBy)) {
            SimpleFilterDef f = new SimpleFilterDef();
            f.setColumn(column);
            f.setNeedEvaluate(true);
            f.setOp("=");
            f.setValue(column);
            this.filters.add(f);
        }
    }

    public void addFilter(SimpleFilterDef f) {
        this.filters.add(f);
    }

    public List<SimpleFilterDef> getFilters() {
        return this.filters;
    }

    public void setFilters(List<SimpleFilterDef> filters) {
        this.filters = filters;
    }
}

