/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.item;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.DropDownItem;
import com.pmease.quickbuild.plugin.report.engine.web.ImageLinkPanel;
import com.pmease.quickbuild.plugin.report.engine.web.LinkPanel;
import com.pmease.quickbuild.web.behavior.PopupBehavior;
import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.IAjaxIndicatorAware;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class DropDownItemPanel
extends Panel
implements IAjaxIndicatorAware {
    private static final long serialVersionUID = 1L;
    final DropDownItem item;

    public DropDownItemPanel(String id, final DropDownItem item, final IModel<ItemContext> model) {
        super(id, model);
        this.item = item;
        ItemContext context = (ItemContext)model.getObject();
        Component trigger = this.createTrigger("trigger");
        this.add(new Component[]{trigger});
        if (item.isEnabled(context)) {
            trigger.add(new Behavior[]{new PopupBehavior(){
                private static final long serialVersionUID = 1L;

                protected Component getPopup(String componentId) {
                    Component dropdown = item.createDropDownContent(componentId, (IModel<ItemContext>)model);
                    if (!Strings.isNullOrEmpty((String)item.getDropdownCss())) {
                        dropdown.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)("dropdown " + item.getDropdownCss()))), " ")});
                    }
                    return dropdown;
                }
            }.hoverMode(item.isHoverMode())});
            this.add(new Component[]{trigger});
        } else if (item.useImage()) {
            trigger.setVisible(false);
        } else {
            trigger.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)"disabled")), " ")});
        }
    }

    public Component createTrigger(String id) {
        String tooltip;
        String color;
        Panel c;
        ItemContext context = (ItemContext)this.getDefaultModelObject();
        String text = this.item.getText(context);
        if (this.item.useImage()) {
            String imagePath = "/images";
            imagePath = this.item.getImageUrl().charAt(0) == '/' ? imagePath + this.item.getImageUrl() : imagePath + "/" + this.item.getImageUrl();
            c = new ImageLinkPanel(id, (IModel)Model.of((Serializable)((Object)imagePath))){
                private static final long serialVersionUID = 1L;

                @Override
                protected AbstractLink createLink(String id) {
                    AbstractLink link = DropDownItemPanel.this.createTriggerLink(id);
                    return link;
                }
            };
        } else {
            c = new LinkPanel(id, text, this.item.isEscaped()){
                private static final long serialVersionUID = 1L;

                @Override
                protected AbstractLink createLink(String id) {
                    AbstractLink link = DropDownItemPanel.this.createTriggerLink(id);
                    return link;
                }
            };
        }
        String css = this.item.getCss();
        if (!Strings.isNullOrEmpty((String)css)) {
            c.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)css)), " ")});
        }
        if (!Strings.isNullOrEmpty((String)(color = this.item.getColor(context)))) {
            c.add(new Behavior[]{new AttributeAppender("style", (IModel)Model.of((Serializable)((Object)("color: " + color))), ";")});
        }
        if (!Strings.isNullOrEmpty((String)(tooltip = this.item.getTooltip(context)))) {
            c.add(new Behavior[]{new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)tooltip)))});
        }
        return c;
    }

    protected AbstractLink createTriggerLink(String id) {
        return new AbstractLink(id){
            private static final long serialVersionUID = 1L;
        };
    }

    public String getAjaxIndicatorMarkupId() {
        return "empty-ajax-indicator";
    }
}

