/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.item;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.DropDownItemPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.PopupItem;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;

public class DropDownItem
extends PopupItem {
    private static final long serialVersionUID = 1L;
    @Alias
    private boolean hoverMode = true;
    @Alias(name="template")
    private String template;

    public DropDownItem(AbstractRenderer renderer) {
        super(renderer);
    }

    @Override
    public Component createComponent(String id, IModel<ItemContext> model) {
        return new DropDownItemPanel(id, this, model);
    }

    public Component createDropDownContent(String id, IModel<ItemContext> model) {
        ItemContext context = (ItemContext)model.getObject();
        if (Strings.isNullOrEmpty((String)this.template)) {
            Preconditions.checkNotNull((Object)this.getPopupRenderer(), (Object)"Either popup renderer or popup template should be defined!");
            return this.createContent(id, context);
        }
        Map<String, Object> ec = this.buildExpressionContext(context);
        String str = ReportHelper.evaluateVelocity(this.getTemplate(), ec);
        return new Label(id, str).setEscapeModelStrings(false);
    }

    @Override
    public String getType() {
        return "DROPDOWN";
    }

    public boolean isHoverMode() {
        return this.hoverMode;
    }

    public void setHoverMode(boolean hoverMode) {
        this.hoverMode = hoverMode;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }
}

