/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.item;

import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.CoverageItem;
import com.pmease.quickbuild.plugin.report.engine.util.MathUtils;
import com.pmease.quickbuild.plugin.report.engine.web.ColorBar;
import java.io.Serializable;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class CoverageItemPanel
extends Panel {
    private static final long serialVersionUID = 1L;

    public CoverageItemPanel(String id, IModel<ItemContext> model, CoverageItem item) {
        super(id);
        ItemContext context = (ItemContext)model.getObject();
        int detected = item.getDetectedNumber(context);
        int total = item.getTotalNumber(context);
        double coverage = MathUtils.divide(detected, total);
        String color = item.getCoverageColor(coverage, context);
        double ratio = 0.65;
        Set<CoverageItem.DisplayType> displayTypes = item.getDisplayTypes();
        boolean hasBar = displayTypes.contains((Object)CoverageItem.DisplayType.BAR);
        this.add(new Component[]{new ColorBar("bar", coverage * ratio, color).setVisible(hasBar)});
        WebMarkupContainer span = new WebMarkupContainer("span");
        this.add(new Component[]{span});
        if (!hasBar) {
            span.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)"nobar")), " ")});
        }
        Label coverageLabel = hasBar ? new Label("coverage", DataTypes.PERCENT.asString(coverage, "#%")) : new Label("coverage", DataTypes.PERCENT.asString(coverage));
        if (!displayTypes.contains((Object)CoverageItem.DisplayType.BAR)) {
            coverageLabel.add(new Behavior[]{new AttributeAppender("style", (IModel)Model.of((Serializable)((Object)("color:" + color))), ";")});
        }
        span.add(new Component[]{coverageLabel.setVisible(displayTypes.contains((Object)CoverageItem.DisplayType.COVERAGE))});
        span.add(new Component[]{new Label("detected", DataTypes.INTEGER.asString(detected)).setVisible(displayTypes.contains((Object)CoverageItem.DisplayType.DETAIL))});
        span.add(new Component[]{new Label("total", DataTypes.INTEGER.asString(total)).setVisible(displayTypes.contains((Object)CoverageItem.DisplayType.DETAIL))});
    }
}

