/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.item;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.CoverageItemPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.RendererItem;
import com.pmease.quickbuild.plugin.report.engine.util.MathUtils;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.dom4j.Element;

public class CoverageItem
extends RendererItem {
    private static final long serialVersionUID = 1L;
    @Alias
    private String detectedColumn;
    @Alias
    private String totalColumn;
    @Alias
    private String displayType;

    public CoverageItem(AbstractRenderer renderer) {
        super(renderer);
    }

    @Override
    public String getType() {
        return "COVERAGE_ITEM";
    }

    @Override
    public Component createComponent(String id, IModel<ItemContext> model) {
        Set<DisplayType> displayTypes = this.getDisplayTypes();
        Preconditions.checkArgument((displayTypes.size() > 0 ? 1 : 0) != 0, (Object)"displayType MUST be defined.");
        CoverageItemPanel c = new CoverageItemPanel(id, model, this);
        if (!Strings.isNullOrEmpty((String)this.getCss())) {
            c.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)this.getCss())), " ")});
        }
        return c;
    }

    public String getCoverageColor(double coverage, ItemContext context) {
        if (Strings.isNullOrEmpty((String)this.getColorExpression())) {
            return ReportUtils.getCoverageColor(coverage);
        }
        return super.getColor(context);
    }

    @Override
    public Map<String, Object> buildExpressionContext(ItemContext context) {
        Map<String, Object> map = super.buildExpressionContext(context);
        double coverage = MathUtils.divide(this.getDetectedNumber(context), this.getTotalNumber(context));
        map.put("COVERAGE", coverage);
        return map;
    }

    public int getDetectedNumber(ItemContext context) {
        Map<String, Object> map = context.getExpressionContext();
        return MapUtils.getIntValue(map, (Object)this.getDetectedColumn(), (int)0);
    }

    public int getTotalNumber(ItemContext context) {
        Map<String, Object> map = context.getExpressionContext();
        return MapUtils.getIntValue(map, (Object)this.getTotalColumn(), (int)0);
    }

    public Set<DisplayType> getDisplayTypes() {
        String displayType = this.getDisplayType();
        String[] tokens = ReportUtils.splitCsv(displayType);
        HashSet set = Sets.newHashSet();
        for (String each : tokens) {
            set.add(DisplayType.valueOf(each));
        }
        return set;
    }

    @Override
    public void fromXML(Element node) {
        super.fromXML(node);
        if (Strings.isNullOrEmpty((String)this.displayType)) {
            throw new QuickbuildException("DisplayType MUST be defined.");
        }
    }

    public String getDetectedColumn() {
        return this.detectedColumn;
    }

    public void setDetectedColumn(String detectedColumn) {
        this.detectedColumn = detectedColumn;
    }

    public String getTotalColumn() {
        return this.totalColumn;
    }

    public void setTotalColumn(String totalColumn) {
        this.totalColumn = totalColumn;
    }

    public String getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(String displayType) {
        this.displayType = displayType;
    }

    public static enum DisplayType {
        BAR,
        COVERAGE,
        DETAIL;

    }
}

