/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.item;

import com.google.common.base.Objects;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.TextItem;
import com.pmease.quickbuild.plugin.report.engine.web.LinkPanel;
import com.pmease.quickbuild.web.page.BasePage;
import com.pmease.quickbuild.web.page.configuration.ConfigurationPage;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class ConfigurationItem
extends TextItem {
    private static final long serialVersionUID = 1L;

    public ConfigurationItem(AbstractRenderer renderer) {
        super(renderer);
    }

    @Override
    public String getType() {
        return "CONFIGURATION_ITEM";
    }

    @Override
    public Component createComponent(String id, IModel<ItemContext> model) {
        ItemContext context = (ItemContext)model.getObject();
        final Long configurationId = (Long)this.getValue(context);
        Long renderFor = Context.getConfiguration().getId();
        AbstractRenderer r = this.getRenderer();
        if (Objects.equal((Object)renderFor, (Object)configurationId) && !r.isInGadget()) {
            return new Label(id, "<i>This configuration</i>").setEscapeModelStrings(false);
        }
        Configuration c = (Configuration)BasePage.get().getConfigurations().get(configurationId);
        if (c == null) {
            return new WebMarkupContainer(id).setVisible(false);
        }
        LinkPanel panel = new LinkPanel(id, (IModel)Model.of((Serializable)((Object)c.getPathName())), true){

            @Override
            protected AbstractLink createLink(String id) {
                BookmarkablePageLink link = new BookmarkablePageLink(id, ConfigurationPage.class, ConfigurationPage.params4((Long)configurationId));
                link.add(new Behavior[]{AttributeAppender.append((String)"class", (Serializable)((Object)"trunc-text"))});
                return link;
            }
        };
        return panel;
    }
}

