/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.item;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.CompositeItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.RendererItem;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public class CompositeItemPanel
extends Panel {
    private static final long serialVersionUID = 1L;

    public CompositeItemPanel(String id, CompositeItem item, IModel<ItemContext> model) {
        super(id, model);
        this.add(new Component[]{this.createItemsView("items", item).setRenderBodyOnly(true)});
    }

    protected Component createItemsView(String id, final CompositeItem rendererItem) {
        return new ListView<RendererItem>(id, rendererItem.getItems()){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<RendererItem> item) {
                int index = item.getIndex();
                RendererItem each = (RendererItem)item.getModelObject();
                item.add(new Component[]{each.createComponent("item", (IModel<ItemContext>)CompositeItemPanel.this.getDefaultModel())});
                if (Strings.isNullOrEmpty((String)rendererItem.getDelimiter()) || index + 1 == this.size()) {
                    item.add(new Component[]{new WebMarkupContainer("delimiter").setVisible(false)});
                } else {
                    item.add(new Component[]{new Label("delimiter", rendererItem.getDelimiter()).setRenderBodyOnly(true)});
                }
                item.setRenderBodyOnly(true);
            }
        };
    }
}

