/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.item;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.CompositeItemPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.RendererItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.TextItem;
import com.pmease.quickbuild.plugin.report.engine.util.TypedObjects;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.dom4j.Element;

public class CompositeItem
extends RendererItem {
    private static final long serialVersionUID = 1L;
    @Alias
    String delimiter;
    protected List<RendererItem> items = Lists.newArrayList();

    public CompositeItem(AbstractRenderer renderer) {
        super(renderer);
    }

    @Override
    public String getType() {
        return "COMPOSITE";
    }

    @Override
    public Component createComponent(String id, IModel<ItemContext> model) {
        return new CompositeItemPanel(id, this, model);
    }

    public List<RendererItem> getItems() {
        return this.items;
    }

    public void setItems(List<RendererItem> items) {
        this.items = items;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    @Override
    public void fromXML(Element node) {
        super.fromXML(node);
        List nodes = node.elements("item");
        for (Element each : nodes) {
            RendererItem item = TypedObjects.createTypedObject(each, RendererItem.class, this.createDefaultItem(), this.getRenderer());
            item.fromXML(each);
            this.addItem(item);
        }
    }

    protected RendererItem createDefaultItem() {
        return new TextItem(this.getRenderer());
    }

    public void addItem(RendererItem item) {
        this.items.add(item);
    }
}

