/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.item;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.TextItem;
import com.pmease.quickbuild.plugin.report.engine.web.ColorBar;
import com.pmease.quickbuild.plugin.report.engine.web.ColorBarWithLabel;
import com.pmease.quickbuild.util.VelocityUtils;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;

public class BarItem
extends TextItem {
    private static final long serialVersionUID = 1L;
    @Alias
    private boolean withLabel = true;
    @Alias
    private String barLabel;
    @Alias
    private double ratio = 0.8;

    public BarItem(AbstractRenderer renderer) {
        super(renderer);
    }

    @Override
    public String getType() {
        return "BAR";
    }

    @Override
    public Component createComponent(String id, IModel<ItemContext> model) {
        ItemContext context = (ItemContext)model.getObject();
        Object value = this.getValue(context);
        double percent = 0.0;
        if (value != null) {
            percent = ((Number)value).doubleValue();
        }
        String color = this.getColor(context);
        String barLabel = this.getBarLabel(context);
        if (!this.isWithLabel()) {
            return new ColorBar(id, percent * this.ratio, color);
        }
        return new ColorBarWithLabel(id, percent, color, barLabel, this.isWithLabel());
    }

    protected String getBarLabel(ItemContext context) {
        if (Strings.isNullOrEmpty((String)this.getBarLabel())) {
            return DataTypes.PERCENT.asString(this.getValue(context), "#%");
        }
        return VelocityUtils.evalTemplate((String)this.getBarLabel(), this.buildExpressionContext(context));
    }

    public String getBarLabel() {
        return this.barLabel;
    }

    public void setBarLabel(String barLabel) {
        this.barLabel = barLabel;
    }

    public boolean isWithLabel() {
        return this.withLabel;
    }

    public void setWithLabel(boolean withLabel) {
        this.withLabel = withLabel;
    }

    public double getRatio() {
        return this.ratio;
    }

    public void setRatio(double ratio) {
        this.ratio = ratio;
    }
}

