/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.item;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.TextItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.TextItemPanel;
import com.pmease.quickbuild.plugin.report.engine.web.ImageLinkPanel;
import com.pmease.quickbuild.plugin.report.engine.web.LinkPanel;
import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class AbstractLinkItem
extends TextItem {
    private static final long serialVersionUID = 1L;
    @Alias(name="enabled")
    protected String enabledExpression;
    @Alias(name="imageUrl")
    protected String imageUrl;

    protected abstract AbstractLink doCreateLink(String var1, ItemContext var2);

    public AbstractLinkItem(AbstractRenderer renderer) {
        super(renderer);
    }

    @Override
    public Component createComponent(String id, final IModel<ItemContext> contextModel) {
        return new TextItemPanel(id, this, contextModel){
            private static final long serialVersionUID = 1L;

            @Override
            protected Component createValueItem(String id) {
                Component c;
                ItemContext context = (ItemContext)contextModel.getObject();
                String text = AbstractLinkItem.this.getText(context);
                if (AbstractLinkItem.this.useImage()) {
                    c = AbstractLinkItem.this.createImageLink(id, context, text);
                } else {
                    if (Strings.isNullOrEmpty((String)text)) {
                        return new WebMarkupContainer(id).setVisible(false);
                    }
                    c = AbstractLinkItem.this.createTextLink(id, context, text);
                }
                this.afterComponentCreated(c, context, text);
                return c;
            }
        };
    }

    public boolean useImage() {
        return !Strings.isNullOrEmpty((String)this.imageUrl);
    }

    public boolean isEnabled(ItemContext context) {
        if (Strings.isNullOrEmpty((String)this.enabledExpression)) {
            return true;
        }
        return (Boolean)ReportHelper.evaluate(this.enabledExpression, this.buildExpressionContext(context));
    }

    protected AbstractLink createLink(String linkId, ItemContext context, String text) {
        String tooltip;
        AbstractLink link = this.doCreateLink(linkId, context);
        if (!this.isEnabled(context)) {
            link.setEnabled(false);
            if (this.useImage()) {
                link.setVisible(false);
                return link;
            }
        }
        if (this.useImage()) {
            return link;
        }
        String color = this.getColor(context);
        if (!Strings.isNullOrEmpty((String)color)) {
            link.add(new Behavior[]{new AttributeModifier("style", (IModel)Model.of((Serializable)((Object)("color:" + color))))});
        }
        if (!Strings.isNullOrEmpty((String)(tooltip = this.getTooltip(context)))) {
            link.add(new Behavior[]{new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)tooltip)))});
        }
        if (!Strings.isNullOrEmpty((String)this.css)) {
            link.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)this.css)), " ")});
        }
        return link;
    }

    protected Component createImageLink(String id, final ItemContext context, final String text) {
        String imagePath = "/images";
        imagePath = this.imageUrl.charAt(0) == '/' ? imagePath + this.imageUrl : imagePath + "/" + this.imageUrl;
        return new ImageLinkPanel(id, (IModel)new Model((Serializable)((Object)imagePath))){
            private static final long serialVersionUID = 1L;

            @Override
            protected AbstractLink createLink(String linkId) {
                return AbstractLinkItem.this.createLink(linkId, context, text);
            }
        };
    }

    protected Component createTextLink(String id, final ItemContext context, final String text) {
        return new LinkPanel(id, text, this.isEscaped()){
            private static final long serialVersionUID = 1L;

            @Override
            protected AbstractLink createLink(String id) {
                return AbstractLinkItem.this.createLink(id, context, text);
            }
        };
    }

    public String getEnabledExpression() {
        return this.enabledExpression;
    }

    public void setEnabledExpression(String enabledExpression) {
        this.enabledExpression = enabledExpression;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }
}

