/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.historystats;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.datastore.ReportDataSource;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.historystats.HistoryStatsPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsRenderer;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.dom4j.Element;

public class HistoryStatsRenderer
extends StatisticsRenderer {
    private static final long serialVersionUID = 1L;
    @Alias
    private String buildColumn;
    @Alias
    private int maxSize = 25;
    private List<StatisticsItem> valueItems = Lists.newArrayList();

    public HistoryStatsRenderer(ReportCategory category) {
        super(category);
    }

    @Override
    public String getType() {
        return "HISTORY_STATS";
    }

    @Override
    public Panel createReportPanel(String id, IModel<RendererContext> model) {
        return new HistoryStatsPanel(id, this, model);
    }

    @Override
    public void fromXML(Element node) {
        super.fromXML(node);
        ReportDataSource rds = this.getDataSource();
        String reportName = rds.getFrom();
        List elements = node.selectNodes("./valueItem");
        for (Element each : elements) {
            StatisticsItem item = new StatisticsItem(this.category);
            item.setReportName(reportName);
            item.fromXML(each);
            this.valueItems.add(item);
        }
    }

    public String[] getColumnNames() {
        ArrayList names = Lists.newArrayList();
        names.add(this.buildColumn);
        for (StatisticsItem each : this.valueItems) {
            names.add(each.getValueExpression());
        }
        return (String[])Iterables.toArray((Iterable)names, String.class);
    }

    public String getBuildColumn() {
        return this.buildColumn;
    }

    public void setBuildColumn(String buildColumn) {
        this.buildColumn = buildColumn;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public List<StatisticsItem> getValueItems() {
        return this.valueItems;
    }

    public void setValueItems(List<StatisticsItem> valueItems) {
        this.valueItems = valueItems;
    }
}

