/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.historystats;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.datatype.ListType;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractReportPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.CompareOption;
import com.pmease.quickbuild.plugin.report.engine.renderer.GroupOption;
import com.pmease.quickbuild.plugin.report.engine.renderer.LineChartOption;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.chart.line.LineChart;
import com.pmease.quickbuild.plugin.report.engine.renderer.chart.line.LineChartData;
import com.pmease.quickbuild.plugin.report.engine.renderer.chart.line.LineChartItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.chart.line.LineChartSetting;
import com.pmease.quickbuild.plugin.report.engine.renderer.historystats.HistoryStatsRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsItem;
import com.pmease.quickbuild.plugin.report.engine.util.BuildFragment;
import com.pmease.quickbuild.plugin.report.engine.util.BuildUtils;
import com.pmease.quickbuild.plugin.report.engine.util.Builds;
import com.pmease.quickbuild.web.chart.JFreeChartPanel;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import com.pmease.quickbuild.web.page.configuration.StatisticsPage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.jfree.chart.JFreeChart;

public class HistoryStatsPanel
extends AbstractReportPanel {
    private static final long serialVersionUID = 1L;
    static final int DEFAULT_WIDTH = 560;
    static final int DEFAULT_HEIGHT = 160;

    public HistoryStatsPanel(String id, final HistoryStatsRenderer renderer, IModel<RendererContext> model) {
        super(id, renderer, model);
        this.add(new Component[]{new Label("title", renderer.getTitle())});
        this.add(new Component[]{new JFreeChartPanel("chart", 560, 160, (IModel)new AbstractReadOnlyModel<JFreeChart>(){
            private static final long serialVersionUID = 1L;

            public JFreeChart getObject() {
                LineChart lineChart = HistoryStatsPanel.this.loadLineChart();
                return lineChart.getChart();
            }
        })});
        this.add(new Component[]{new Link<Void>("toStatistics"){
            private static final long serialVersionUID = 1L;

            public void onClick() {
                this.setResponsePage((Page)new StatisticsPage(HistoryStatsPanel.this.getConfiguration().getId(), new String[]{Tab.title2id((String)renderer.getCategory().getName())}));
            }
        }});
    }

    protected LineChart loadLineChart() {
        DataReport report = this.getDefaultReport();
        ArrayList series = Lists.newArrayList();
        List<StatisticsItem> items = this.getRenderer().getValueItems();
        LineChartOption option = new LineChartOption();
        option.setPrimaryItem(items.get(0));
        if (items.size() > 1) {
            option.setCompareOption(CompareOption.OTHER_METRICS);
            ArrayList comparisonItems = Lists.newArrayList();
            for (int i = 1; i < items.size(); ++i) {
                comparisonItems.add(items.get(i));
            }
            option.setComparisonItems(comparisonItems);
        }
        if (report == null || report.isEmpty()) {
            return new LineChart(series, true, option);
        }
        DataRow row = report.getRow(0);
        List ids = (List)row.getValue(this.getRenderer().getBuildColumn());
        if (ids.isEmpty()) {
            return new LineChart(series, true, option);
        }
        Builds builds = BuildUtils.getBuilds(ids, 0);
        if (this.getRenderer().getMaxSize() > 0 && builds.size() > this.getRenderer().getMaxSize()) {
            builds = new Builds(builds.subList(builds.size() - this.getRenderer().getMaxSize(), builds.size()));
        }
        option.setGroupOption(GroupOption.BY_VERSION);
        option.setIgnoreNoBuildDays(true);
        for (StatisticsItem each : items) {
            StatisticsItem s = new StatisticsItem(each);
            ListType dataType = (ListType)each.getDataType();
            s.setDataType(dataType.getItemType());
            LineChartSetting setting = new LineChartSetting(s);
            setting.setTitle(s.getTitle());
            LineChartData data = new LineChartData(setting, option);
            series.add(data);
            List values = (List)row.getValue(each.getValueExpression());
            double max = 0.0;
            double min = Double.MAX_VALUE;
            for (int i = 0; i < builds.size(); ++i) {
                BuildFragment build = (BuildFragment)builds.get(i);
                Integer index = this.getIndexOfBuild(build.getId(), ids);
                if (index == null) continue;
                double value = index >= values.size() ? 0.0 : (Double)DataTypes.DOUBLE.typeCast(values.get(index));
                LineChartItem item = new LineChartItem();
                item.setFromBuild(build);
                item.setToBuild(build);
                if (build.getStatus() == Build.Status.SUCCESSFUL || build.getStatus() == Build.Status.RECOMMENDED) {
                    item.setSucceeded(1);
                } else {
                    item.setFailed(1);
                }
                item.setValidBuilds(1);
                item.setTotalBuilds(1);
                item.setMax(value);
                item.setMin(value);
                item.setValue(value);
                data.addItem(item);
                max = Math.max(value, max);
                min = Math.min(value, min);
            }
            data.setMax(max);
            data.setMin(min);
            data.setPeriodMax(max);
            data.setPeriodMin(min);
        }
        return new LineChart(series, true, option);
    }

    @Override
    public File getDbDir() {
        ReportCategory category = this.renderer.getCategory();
        return category.getReportDirOfStats(this.getConfiguration(), this.getReportSet());
    }

    protected Integer getIndexOfBuild(Long id, List<Long> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (!Objects.equal((Object)id, (Object)list.get(i))) continue;
            return i;
        }
        return null;
    }

    @Override
    public HistoryStatsRenderer getRenderer() {
        return (HistoryStatsRenderer)super.getRenderer();
    }
}

