/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.gadget;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.extensionpoint.support.ConfigurationBasedGadget;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.gadget.GadgetPanel;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class ReportStatisticsGadget
extends ConfigurationBasedGadget {
    private static final long serialVersionUID = 1L;
    private List<String> reportsets = new ArrayList<String>();
    private transient AbstractRenderer renderer;

    protected abstract AbstractRenderer createRenderer();

    @Editable(name="Report Sets", description="Specify the report sets you want to display, comma to separated. Leave empty if you want to display all repor sets")
    @ChoiceProvider(value="getAvailableReportsets")
    public List<String> getReportsets() {
        return this.reportsets;
    }

    public void setReportsets(List<String> reportsets) {
        this.reportsets = reportsets;
    }

    private static List<String> getAvailableReportsets(Class<?> clazz) {
        ArrayList<String> available = new ArrayList<String>();
        Configuration configuration = ReportStatisticsGadget.guessConfiguration();
        if (configuration != null) {
            try {
                ReportStatisticsGadget gadget = (ReportStatisticsGadget)((Object)clazz.newInstance());
                available.addAll(Arrays.asList(gadget.getRenderer().getCategory().getReportSetsOfStats(configuration)));
            }
            catch (Exception e) {
                throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
            }
        }
        return available;
    }

    protected void checkPermission() {
        if (!SecurityHelper.hasPermission((String)this.getRenderer().getCategory().getName().toUpperCase())) {
            throw new AccessDeniedException("You have no permission to access report " + this.getRenderer().getCategory().getName());
        }
    }

    protected Component renderHeadForConfiguration(String componentId) {
        Configuration c = Context.getConfiguration();
        String url = this.getTitleUrl(c);
        if (c == null || Strings.isNullOrEmpty((String)url)) {
            return super.renderHeadForConfiguration(componentId);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<a class='title-link' href='").append(url).append("'>").append(this.getInterpolatedTitle()).append("</a>");
        return new Label(componentId, sb.toString()).setEscapeModelStrings(false);
    }

    protected String getTitleUrl(Configuration c) {
        if (c == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("/statistics/").append(c.getId()).append("/").append(Tab.title2id((String)this.getRenderer().getCategory().getName()));
        return sb.toString();
    }

    protected Panel renderBodyForConfiguration(String panelId) {
        String[] reportsets;
        this.checkPermission();
        String reportset = StringUtils.join(this.getReportsets(), (String)",");
        if (reportset == null) {
            reportset = "";
        }
        if (Strings.isNullOrEmpty((String)reportset)) {
            AbstractRenderer renderer = this.getRenderer();
            reportsets = renderer.getCategory().getReportSetsOfStats(Context.getConfiguration());
        } else {
            reportsets = (String[])Iterables.toArray((Iterable)Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)reportset), String.class);
        }
        if (reportsets.length == 0) {
            throw new AccessDeniedException("No report found for configuration: " + Context.getConfiguration().getPathName());
        }
        RendererContext rc = new RendererContext();
        this.configureRendererContext(rc);
        return this.createGadgetPanel(panelId, reportsets, (IModel<RendererContext>)Model.of((Serializable)rc));
    }

    protected Panel createGadgetPanel(String id, String[] reportsets, IModel<RendererContext> model) {
        return new GadgetPanel(id, this.getRenderer(), reportsets, this.getReportsetsPerPage(), model);
    }

    private int getReportsetsPerPage() {
        return 200;
    }

    public synchronized AbstractRenderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = this.createRenderer();
        }
        return this.renderer;
    }

    protected void configureRendererContext(RendererContext rc) {
    }
}

