/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.gadget;

import com.pmease.quickbuild.annotation.Choices;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.dashboard.DashboardModule;
import com.pmease.quickbuild.plugin.report.engine.renderer.dashboard.DashboardRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.gadget.ReportBuildGadget;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.datagrid.DataGrid;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.toolbar.SearchNavToolbar;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.toolbar.SearchNavToolbarCreator;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.toolbar.ToolbarCreator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.hibernate.validator.constraints.NotEmpty;

public abstract class ReportGadgetWithTable
extends ReportBuildGadget {
    private static final long serialVersionUID = 1L;
    private String rowsPerPage = "10";

    protected abstract ReportCategory getCategory();

    protected abstract TableRenderer createTableRenderer();

    protected abstract String getToTab();

    @Override
    protected AbstractRenderer createRenderer() {
        ReportCategory category = this.getCategory();
        DashboardRenderer dashboard = new DashboardRenderer(category);
        DashboardModule module = new DashboardModule(dashboard);
        String css = module.getCss();
        if (css == null) {
            css = "";
        }
        module.setCss(css + " autoHeight");
        TableRenderer r = this.createTableRenderer();
        r.setRowsPerPage(Integer.valueOf(this.getRowsPerPage()));
        r.setIgnoreSessionFilter(true);
        css = r.getCss();
        if (css == null) {
            css = "";
        }
        r.setCss(css + " gadget-table");
        r.addToolbar(new SearchNavBar(r));
        module.setRenderer(r);
        module.setToTab(this.getToTab());
        dashboard.addModule(module);
        return dashboard;
    }

    @Editable(name="Rows per page")
    @Choices(value={"5", "10", "20", "50", "100", "200", "500"})
    @NotEmpty
    public String getRowsPerPage() {
        return this.rowsPerPage;
    }

    public void setRowsPerPage(String rowsPerPage) {
        this.rowsPerPage = rowsPerPage;
    }

    protected class SearchNavBar
    extends SearchNavToolbarCreator {
        private static final long serialVersionUID = 1L;

        public SearchNavBar(TableRenderer renderer) {
            super(renderer);
            this.setShowSearchForm(false);
            this.setPosition(ToolbarCreator.ToolbarPosition.BOTTOM);
        }

        @Override
        protected AbstractToolbar doCreate(DataGrid dataGrid, String extraCss) {
            return new SearchNavToolbar(dataGrid, extraCss, this){
                private static final long serialVersionUID = 1L;

                @Override
                public void onConfigure() {
                    super.onConfigure();
                    boolean visible = this.getTable().getRowCount() > Integer.valueOf(ReportGadgetWithTable.this.getRowsPerPage());
                    this.setVisibilityAllowed(visible);
                }
            };
        }
    }
}

