/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.gadget;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.extensionpoint.support.BuildBasedGadget;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.dashboard.DashboardRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.gadget.GadgetPanel;
import com.pmease.quickbuild.plugin.report.engine.util.BuildUtils;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.dom4j.Element;

public abstract class ReportBuildGadget
extends BuildBasedGadget {
    private static final long serialVersionUID = 1L;
    private List<String> reportsets = new ArrayList<String>();
    private String pattern;
    private boolean ignoreCase;
    private transient AbstractRenderer renderer;
    private int reportsetsPerPage = 0;

    protected abstract AbstractRenderer createRenderer();

    @Editable(name="Report Sets", order=800, description="Specify the report sets you want to display. Leave empty if you want to display all repor sets")
    @ChoiceProvider(value="getAvailableReportsets")
    public List<String> getReportsets() {
        return this.reportsets;
    }

    public void setReportsets(List<String> reportsets) {
        this.reportsets = reportsets;
    }

    @Editable(name="Match Pattern", order=900, description="Specify the pattern to filter the report sets. Leave empty if you don't want to filter the report sets. The pattern specified here is using <a href='http://docs.oracle.com/javase/6/docs/api/java/util/regex/Pattern.html'>Java pattern</a>, see <a href='http://docs.oracle.com/javase/6/docs/api/java/util/regex/Pattern.html'>here</a> for more details.")
    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Editable(name="Case Insensitive", order=1000, description="Specify whether the pattern's case is sensitive or not. Only valid when the match pattern above is specified.")
    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    @Editable(name="Reportsets per Page", order=1100, description="Specify the number of report sets per page. 0 to show all report sets")
    public int getReportsetsPerPage() {
        return this.reportsetsPerPage;
    }

    public void setReportsetsPerPage(int reportsetsPerPage) {
        this.reportsetsPerPage = reportsetsPerPage;
    }

    private static List<String> getAvailableReportsets(Class<?> clazz) {
        ArrayList<String> available = new ArrayList<String>();
        Build build = ReportBuildGadget.guessBuild();
        if (build != null) {
            try {
                ReportBuildGadget gadget = (ReportBuildGadget)((Object)clazz.newInstance());
                available.addAll(Arrays.asList(gadget.getRenderer().getCategory().getReportSetsOfBuild(build)));
            }
            catch (Exception e) {
                throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
            }
        }
        return available;
    }

    protected void checkPermission() {
        AbstractRenderer renderer = this.getRenderer();
        ReportCategory category = renderer.getCategory();
        if (!Objects.equal((Object)category, (Object)ReportCategory.NULL_CATEGORY) && !SecurityHelper.hasPermission((String)category.getName().toUpperCase())) {
            throw new AccessDeniedException("You have no permission to access " + renderer.getCategory().getName());
        }
    }

    protected Component renderHeadForBuild(String componentId) {
        Build build = Context.getBuild();
        try {
            String url = this.getTitleUrl(build);
            if (build == null || Strings.isNullOrEmpty((String)url)) {
                return super.renderHeadForBuild(componentId);
            }
            StringBuffer sb = new StringBuffer();
            sb.append("<a class='title-link' href='").append(url).append("'>").append(this.getInterpolatedTitle()).append("</a>");
            return new Label(componentId, sb.toString()).setEscapeModelStrings(false);
        }
        catch (Exception e) {
            return new Label(componentId, e.getMessage());
        }
    }

    protected String getTitleUrl(Build build) {
        if (build == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(BuildUtils.getBuildUrl(build.getId())).append("/").append(Tab.title2id((String)this.getRenderer().getCategory().getName()));
        return sb.toString();
    }

    protected Panel renderBodyForBuild(String panelId) {
        this.checkPermission();
        AbstractRenderer renderer = this.getRenderer();
        String[] reportsets = this.getActualReportsets();
        if (reportsets.length == 0) {
            throw new QuickbuildException(this.getNoReportSetErrorMessage());
        }
        RendererContext rc = new RendererContext();
        this.configureRendererContext(rc);
        return new GadgetPanel(panelId, renderer, reportsets, this.getReportsetsPerPage(), (IModel<RendererContext>)Model.of((Serializable)rc));
    }

    protected String getNoReportSetErrorMessage() {
        return "No build report found or no matched report sets found for build " + Context.getBuild().getVersion();
    }

    protected String[] getActualReportsets() {
        List<String> defined = this.getReportsets();
        String[] actual = defined != null && !defined.isEmpty() ? (String[])Iterables.toArray(defined, String.class) : this.getRenderer().getCategory().getReportSetsOfBuild(Context.getBuild());
        if (!Strings.isNullOrEmpty((String)this.getPattern()) && actual != null && actual.length > 0) {
            try {
                ArrayList matches = Lists.newArrayList();
                int flags = 64;
                if (this.isIgnoreCase()) {
                    flags |= 2;
                }
                Pattern p = Pattern.compile(this.getPattern(), flags);
                for (String each : actual) {
                    if (!p.matcher(each).matches()) continue;
                    matches.add(each);
                }
                actual = (String[])Iterables.toArray((Iterable)matches, String.class);
            }
            catch (Throwable e) {
                throw new QuickbuildException("Match pattern error: " + e.getMessage(), e);
            }
        }
        return actual;
    }

    public synchronized AbstractRenderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = this.createRenderer();
            if (this.renderer instanceof DashboardRenderer) {
                ((DashboardRenderer)this.renderer).setPaging(false);
            }
            this.renderer.setContentOnly(true);
        }
        return this.renderer;
    }

    protected void configureRendererContext(RendererContext rc) {
    }

    public Component createHeader(String componentId) {
        StringBuffer sb = new StringBuffer();
        Build build = Context.getBuild();
        if (build == null) {
            sb.append(this.getInterpolatedTitle());
        } else {
            sb.append("<a href='/build/").append(build.getId()).append("/").append(Tab.title2id((String)this.getRenderer().getCategory().getName())).append("'>").append(this.getInterpolatedTitle()).append("</a>");
        }
        return new Label(componentId, sb.toString()).setEscapeModelStrings(false);
    }

    private void updateElementValue(Element root, String fieldName, String value) {
        Element e = root.element(fieldName);
        if (e == null) {
            e = root.addElement(fieldName);
            e.setText(value);
        }
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        Element root = dom.getRootElement();
        this.updateElementValue(root, "reportsetsPerPage", "0");
        this.updateElementValue(root, "ignoreCase", "false");
        this.updateElementValue(root, "pattern", "");
    }
}

