/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.gadget;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.plugin.report.engine.renderer.CompareOption;
import com.pmease.quickbuild.plugin.report.engine.renderer.GroupOption;
import com.pmease.quickbuild.plugin.report.engine.renderer.LineChartOption;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.gadget.ReportStatisticsGadget;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsRenderer;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.NotEmpty;

public abstract class LineChartGadget
extends ReportStatisticsGadget {
    private static final long serialVersionUID = 1L;
    private List<String> indicators = Lists.newArrayList();
    private String groupBy = GroupOption.BY_DAY.name();
    private boolean excludingFailed = false;
    private boolean ignoreNoBuildDays = false;

    @Override
    protected abstract StatisticsRenderer createRenderer();

    @Override
    protected void configureRendererContext(RendererContext rc) {
        LineChartOption option = new LineChartOption();
        option.setIgnoreNoBuildDays(this.isIgnoreNoBuildDays());
        option.setExcludingFailed(this.isExcludingFailed());
        option.setGroupOption(GroupOption.valueOf(this.getGroupBy()));
        List<String> indicators = this.getIndicators();
        option.setPrimaryItem(this.getStatisticsItem(indicators.get(0)));
        ArrayList compared = Lists.newArrayList();
        for (int i = 1; i < indicators.size(); ++i) {
            compared.add(this.getStatisticsItem(indicators.get(i)));
        }
        option.setComparisonItems(compared);
        if (indicators.size() > 1) {
            option.setCompareOption(CompareOption.OTHER_METRICS);
        } else {
            option.setCompareOption(CompareOption.ONE_METRIC);
        }
        rc.setLineChartOption(option);
    }

    protected StatisticsItem getStatisticsItem(String name) {
        for (StatisticsItem each : this.getRenderer().getItems()) {
            if (!each.getTitle().equalsIgnoreCase(name)) continue;
            return each;
        }
        throw new QuickbuildException("Unable to find indicator " + name + " in renderer " + this.getRenderer().getId());
    }

    @Override
    public StatisticsRenderer getRenderer() {
        return (StatisticsRenderer)super.getRenderer();
    }

    @Editable(name="Indicators", order=400)
    @ChoiceProvider(value="getAvailableIndicators")
    @Size(min=1, max=100)
    public List<String> getIndicators() {
        return this.indicators;
    }

    public void setIndicators(List<String> indicators) {
        this.indicators = indicators;
    }

    @Editable(name="Group By", order=500)
    @NotEmpty
    @ChoiceProvider(value="getGroupOptions")
    public String getGroupBy() {
        return this.groupBy;
    }

    private static List<String> getGroupOptions() {
        ArrayList list = Lists.newArrayList();
        for (GroupOption each : GroupOption.values()) {
            list.add(each.name());
        }
        return list;
    }

    public void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }

    @Editable(name="Excluding failed builds", order=600)
    public boolean isExcludingFailed() {
        return this.excludingFailed;
    }

    public void setExcludingFailed(boolean excludingFailed) {
        this.excludingFailed = excludingFailed;
    }

    @Editable(name="Ignore no build days", order=700)
    public boolean isIgnoreNoBuildDays() {
        return this.ignoreNoBuildDays;
    }

    public void setIgnoreNoBuildDays(boolean ignoreNoBuildDays) {
        this.ignoreNoBuildDays = ignoreNoBuildDays;
    }
}

