/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.gadget;

import com.google.common.collect.ImmutableList;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.SessionData;
import com.pmease.quickbuild.plugin.report.engine.renderer.gadget.GadgetPageChanged;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class GadgetPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private final AbstractRenderer renderer;
    private final String[] reportsets;
    private int reportsetsPerPage = 0;
    private int pageNum = 0;

    public GadgetPanel(String id, AbstractRenderer renderer, String[] reportsets, int reportsetsPerPage, IModel<RendererContext> model) {
        super(id, model);
        this.renderer = renderer;
        this.reportsets = reportsets;
        this.reportsetsPerPage = reportsetsPerPage == 0 ? Integer.MAX_VALUE : reportsetsPerPage;
    }

    private RendererContext getRendererContext() {
        return (RendererContext)this.getDefaultModelObject();
    }

    protected void onInitialize() {
        super.onInitialize();
        this.setOutputMarkupId(true);
        if (this.reportsets.length == 0) {
            this.add(new Component[]{new WebMarkupContainer("sections").setVisible(false)});
        } else {
            SessionData.get().clear();
            final boolean visible = this.reportsets.length > 1;
            AbstractReadOnlyModel<List<String>> model = new AbstractReadOnlyModel<List<String>>(){

                public List<String> getObject() {
                    List<String> list = GadgetPanel.this.getDisplayableReportsets();
                    return list;
                }
            };
            this.add(new Component[]{new ListView<String>("sections", (IModel)model){
                private static final long serialVersionUID = 1L;

                protected void populateItem(ListItem<String> item) {
                    String reportset = (String)item.getModelObject();
                    RendererContext old = GadgetPanel.this.getRendererContext();
                    RendererContext rc = new RendererContext(old);
                    rc.setReportSet(reportset);
                    if (item.getIndex() == 0) {
                        item.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)"first")), " ")});
                    }
                    if (item.getIndex() == this.getList().size() - 1) {
                        item.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)"last")), " ")});
                    }
                    item.add(new Component[]{new Label("reportset", reportset).setVisible(visible)});
                    item.add(new Component[]{GadgetPanel.this.renderer.render("content", (IModel<RendererContext>)Model.of((Serializable)rc))});
                }
            }});
            this.add(new Component[]{this.createGadgetFooter("footer")});
        }
    }

    private void broadcastPageChangedEvent(AjaxRequestTarget target) {
        this.send((IEventSink)this, Broadcast.BREADTH, new GadgetPageChanged(target, (Integer)this.pageNum));
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof GadgetPageChanged) {
            ((GadgetPageChanged)event.getPayload()).getTarget().add(new Component[]{this});
        }
    }

    protected int getFrom() {
        int from = this.reportsetsPerPage * this.pageNum;
        return from > this.reportsets.length - 1 ? this.reportsets.length - 1 : from;
    }

    protected int getTo() {
        int to = (this.pageNum + 1) * this.reportsetsPerPage - 1;
        if (to > this.reportsets.length - 1) {
            to = this.reportsets.length - 1;
        }
        return to;
    }

    private int totalPages() {
        if (this.reportsets.length == 0) {
            return 0;
        }
        if (this.reportsets.length % this.reportsetsPerPage == 0) {
            return this.reportsets.length / this.reportsetsPerPage;
        }
        return this.reportsets.length / this.reportsetsPerPage + 1;
    }

    protected List<String> getDisplayableReportsets() {
        ImmutableList available = ImmutableList.copyOf((Object[])this.reportsets);
        return ImmutableList.copyOf(available.subList(this.getFrom(), this.getTo() + 1));
    }

    protected Component createGadgetFooter(String id) {
        WebMarkupContainer span = new WebMarkupContainer("navbar");
        span.add(new Component[]{new Label("pageInfo", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                return GadgetPanel.this.getFrom() + 1 + " to " + (GadgetPanel.this.getTo() + 1) + " of " + GadgetPanel.this.reportsets.length;
            }
        })});
        span.add(new Component[]{new AjaxLink<Void>("previous"){

            public void onClick(AjaxRequestTarget target) {
                GadgetPanel.this.pageNum--;
                GadgetPanel.this.pageNum = Math.max(GadgetPanel.this.pageNum, 0);
                GadgetPanel.this.pageNum = Math.min(GadgetPanel.this.pageNum, GadgetPanel.this.totalPages() - 1);
                GadgetPanel.this.broadcastPageChangedEvent(target);
            }
        }.add(new Behavior[]{AttributeAppender.append((String)"class", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                return GadgetPanel.this.pageNum == 0 ? "disabled" : "";
            }
        })})});
        span.add(new Component[]{new AjaxLink<Void>("next"){

            public void onClick(AjaxRequestTarget target) {
                GadgetPanel.this.pageNum++;
                GadgetPanel.this.pageNum = Math.max(GadgetPanel.this.pageNum, 0);
                GadgetPanel.this.pageNum = Math.min(GadgetPanel.this.pageNum, GadgetPanel.this.totalPages() - 1);
                GadgetPanel.this.broadcastPageChangedEvent(target);
            }
        }.add(new Behavior[]{AttributeAppender.append((String)"class", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                return GadgetPanel.this.pageNum == GadgetPanel.this.totalPages() - 1 ? "disabled" : "";
            }
        })})});
        span.add(new Component[]{new AjaxLink<Void>("firstPage"){

            public void onClick(AjaxRequestTarget target) {
                GadgetPanel.this.pageNum = 0;
                GadgetPanel.this.broadcastPageChangedEvent(target);
            }
        }.add(new Behavior[]{AttributeAppender.append((String)"class", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                return GadgetPanel.this.pageNum == 0 ? "disabled" : "";
            }
        })})});
        span.add(new Component[]{new AjaxLink<Void>("lastPage"){

            public void onClick(AjaxRequestTarget target) {
                GadgetPanel.this.pageNum = GadgetPanel.this.totalPages() - 1;
                GadgetPanel.this.broadcastPageChangedEvent(target);
            }
        }.add(new Behavior[]{AttributeAppender.append((String)"class", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                return GadgetPanel.this.pageNum == GadgetPanel.this.totalPages() - 1 ? "disabled" : "";
            }
        })})});
        span.setVisibilityAllowed(this.reportsetsPerPage < this.reportsets.length);
        return span;
    }
}

