/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.gadget;

import com.google.common.base.Strings;
import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.aggregationsupport.Aggregation;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.extensionpoint.support.ConfigurationBasedGadget;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.ExceptionUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.hibernate.validator.constraints.NotEmpty;

public abstract class AggregatedReportGadget
extends ConfigurationBasedGadget {
    private static final long serialVersionUID = 1L;
    private String aggregationName;
    private transient AbstractRenderer renderer;

    protected abstract AbstractRenderer createRenderer();

    protected abstract boolean isValidAggregation(Aggregation var1);

    protected Panel renderBodyForConfiguration(String panelId) {
        this.checkPermission();
        RendererContext rc = new RendererContext();
        rc.setReportSet(this.getAggregationName());
        this.configureRendererContext(rc);
        return this.getRenderer().createReportPanel(panelId, (IModel<RendererContext>)Model.of((Serializable)rc));
    }

    protected Component renderHeadForConfiguration(String componentId) {
        Configuration c = Context.getConfiguration();
        String url = this.getTitleUrl(c);
        if (c == null || Strings.isNullOrEmpty((String)url)) {
            return super.renderHeadForConfiguration(componentId);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<a class='title-link' href='").append(url).append("'>").append(this.getInterpolatedTitle()).append("</a>");
        return new Label(componentId, sb.toString()).setEscapeModelStrings(false);
    }

    protected String getTitleUrl(Configuration c) {
        if (c == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("/overview/").append(c.getId());
        return sb.toString();
    }

    protected void checkPermission() {
        AbstractRenderer renderer = this.getRenderer();
        if (!SecurityHelper.hasPermission((String)renderer.getCategory().getName().toUpperCase())) {
            throw new AccessDeniedException("You have no permission to access " + renderer.getCategory().getName());
        }
    }

    @Editable(name="Aggregation Name", description="Specify the aggregation name you want to display.")
    @ChoiceProvider(value="getAvailableAggregations")
    @NotEmpty
    public String getAggregationName() {
        return this.aggregationName;
    }

    public void setAggregationName(String aggregationName) {
        this.aggregationName = aggregationName;
    }

    private static List<String> getAvailableAggregations(Class<?> clazz) {
        ArrayList<String> available = new ArrayList<String>();
        Configuration configuration = AggregatedReportGadget.guessConfiguration();
        if (configuration != null) {
            List aggregations = configuration.findAggregations();
            try {
                AggregatedReportGadget gadget = (AggregatedReportGadget)((Object)clazz.newInstance());
                for (Aggregation each : aggregations) {
                    if (each == null || !gadget.isValidAggregation(each)) continue;
                    available.add(each.getName());
                }
            }
            catch (Exception e) {
                throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
            }
        }
        return available;
    }

    public synchronized AbstractRenderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = this.createRenderer();
            this.renderer.setContentOnly(true);
            this.renderer.setInGadget(true);
        }
        return this.renderer;
    }

    protected void configureRendererContext(RendererContext rc) {
    }
}

