/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.gadget;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.aggregationsupport.Aggregation;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.engine.renderer.GroupOption;
import com.pmease.quickbuild.plugin.report.engine.renderer.aggregation.AggregationStatsRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.gadget.LineChartGadget;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.hibernate.validator.constraints.NotEmpty;

public abstract class AggregatedLineChartGadget
extends LineChartGadget {
    private static final long serialVersionUID = 1L;
    private String aggregationName;

    @Override
    protected abstract AggregationStatsRenderer createRenderer();

    protected abstract boolean isValidAggregation(Aggregation var1);

    protected abstract String getAggregatedTabName();

    @Override
    public List<String> getReportsets() {
        return Lists.newArrayList((Object[])new String[]{this.getAggregationName()});
    }

    @Override
    public boolean isExcludingFailed() {
        return false;
    }

    @Override
    protected Component renderHeadForConfiguration(String componentId) {
        Configuration c = Context.getConfiguration();
        String url = this.getTitleUrl(c);
        if (c == null || Strings.isNullOrEmpty((String)url)) {
            return super.renderHeadForConfiguration(componentId);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<a class='title-link' href='").append(url).append("'>").append(this.getInterpolatedTitle()).append("</a>");
        return new Label(componentId, sb.toString()).setEscapeModelStrings(false);
    }

    @Override
    protected String getTitleUrl(Configuration c) {
        if (c == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("/statistics/").append(c.getId()).append("/").append(Tab.title2id((String)this.getAggregatedTabName()).toLowerCase());
        return sb.toString();
    }

    @Editable(name="Aggregation Name", order=300, description="Specify the aggregation name you want to display.")
    @ChoiceProvider(value="getAvailableAggregations")
    @NotEmpty
    public String getAggregationName() {
        return this.aggregationName;
    }

    public void setAggregationName(String aggregationName) {
        this.aggregationName = aggregationName;
    }

    private static List<String> getGroupOptions() {
        ArrayList list = Lists.newArrayList();
        for (GroupOption each : GroupOption.values()) {
            if (each == GroupOption.BY_VERSION) continue;
            list.add(each.name());
        }
        return list;
    }

    private static List<String> getAvailableAggregations(Class<?> clazz) {
        ArrayList<String> available = new ArrayList<String>();
        Configuration configuration = AggregatedLineChartGadget.guessConfiguration();
        if (configuration != null) {
            List aggregations = configuration.findAggregations();
            try {
                AggregatedLineChartGadget gadget = (AggregatedLineChartGadget)((Object)clazz.newInstance());
                for (Aggregation each : aggregations) {
                    if (each == null || !gadget.isValidAggregation(each)) continue;
                    available.add(each.getName());
                }
            }
            catch (Exception e) {
                throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
            }
        }
        return available;
    }
}

