/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.dashboard;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.SessionData;
import com.pmease.quickbuild.plugin.report.engine.renderer.dashboard.DashboardModule;
import com.pmease.quickbuild.plugin.report.engine.renderer.dashboard.DashboardPageChanged;
import com.pmease.quickbuild.plugin.report.engine.renderer.dashboard.DashboardRenderer;
import com.pmease.quickbuild.web.component.dashboardpanel.AbstractDashboardModulePanel;
import com.pmease.quickbuild.web.component.dashboardpanel.DashboardOverviewPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;

public class ReportDashboardPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    final DashboardRenderer renderer;
    private int pageNum = 0;
    private IModel<List<String>> reportsetModel;
    private static final int reportsetsPerPage = 10;

    public ReportDashboardPanel(String id, final DashboardRenderer renderer, IModel<RendererContext> model) {
        super(id, model);
        this.renderer = renderer;
        this.reportsetModel = new LoadableDetachableModel<List<String>>(){

            protected List<String> load() {
                String reportset = ReportDashboardPanel.this.getContext().getReportSet();
                if (Strings.isNullOrEmpty((String)reportset)) {
                    Build build = ReportDashboardPanel.this.getBuild();
                    return ImmutableList.copyOf((Object[])renderer.getCategory().getReportSetsOfBuild(build));
                }
                return ImmutableList.of((Object)reportset);
            }
        };
    }

    public void onInitialize() {
        super.onInitialize();
        SessionData.get().setFilter(null);
        WebMarkupContainer span = new WebMarkupContainer("span");
        if (this.renderer.isPaging()) {
            span.setOutputMarkupId(true);
        } else {
            span.setRenderBodyOnly(true);
        }
        if (!Strings.isNullOrEmpty((String)this.renderer.getCss())) {
            span.add(new Behavior[]{AttributeAppender.append((String)"class", (Serializable)((Object)this.renderer.getCss()))});
        }
        this.add(new Component[]{span});
        AbstractReadOnlyModel<List<String>> sectionModel = new AbstractReadOnlyModel<List<String>>(){

            public List<String> getObject() {
                Object[] reportsets = ReportDashboardPanel.this.getReportSets();
                if (ReportDashboardPanel.this.renderer.isPaging()) {
                    ImmutableList result = ImmutableList.copyOf(Lists.newArrayList((Object[])reportsets).subList(ReportDashboardPanel.this.getFrom(), ReportDashboardPanel.this.getTo() + 1));
                    return result;
                }
                return ImmutableList.copyOf((Object[])reportsets);
            }
        };
        span.add(new Component[]{new ListView<String>("sections", (IModel)sectionModel){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<String> item) {
                String reportset = (String)item.getModelObject();
                RendererContext context = new RendererContext();
                context.setReportSet(reportset);
                ArrayList panels = Lists.newArrayList();
                for (DashboardModule module : ReportDashboardPanel.this.renderer.getModules()) {
                    AbstractDashboardModulePanel panel = ReportDashboardPanel.this.createModulePanel(module, (IModel<RendererContext>)Model.of((Serializable)context));
                    panel.setRenderBodyOnly(true);
                    panels.add(panel);
                }
                DashboardOverviewPanel panel = new DashboardOverviewPanel("section", panels.toArray(new AbstractDashboardModulePanel[panels.size()]));
                item.add(new Component[]{panel});
            }
        }.setRenderBodyOnly(true)});
        if (this.renderer.isPaging()) {
            span.add(new Component[]{this.createPagination("pagination")});
        } else {
            span.add(new Component[]{new WebMarkupContainer("pagination").setVisibilityAllowed(false)});
        }
    }

    protected Component createPagination(String id) {
        WebMarkupContainer span = new WebMarkupContainer(id);
        span.add(new Component[]{new Label("pageInfo", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                return ReportDashboardPanel.this.getFrom() + 1 + " to " + (ReportDashboardPanel.this.getTo() + 1) + " of " + ReportDashboardPanel.this.getReportSets().length;
            }
        })});
        span.add(new Component[]{new AjaxLink<Void>("previous"){

            public void onClick(AjaxRequestTarget target) {
                ReportDashboardPanel.this.pageNum--;
                ReportDashboardPanel.this.pageNum = Math.max(ReportDashboardPanel.this.pageNum, 0);
                ReportDashboardPanel.this.pageNum = Math.min(ReportDashboardPanel.this.pageNum, ReportDashboardPanel.this.totalPages() - 1);
                ReportDashboardPanel.this.broadcastPageChangedEvent(target);
            }
        }.add(new Behavior[]{AttributeAppender.append((String)"class", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                return ReportDashboardPanel.this.pageNum == 0 ? "disabled" : "";
            }
        })})});
        span.add(new Component[]{new AjaxLink<Void>("next"){

            public void onClick(AjaxRequestTarget target) {
                ReportDashboardPanel.this.pageNum++;
                ReportDashboardPanel.this.pageNum = Math.max(ReportDashboardPanel.this.pageNum, 0);
                ReportDashboardPanel.this.pageNum = Math.min(ReportDashboardPanel.this.pageNum, ReportDashboardPanel.this.totalPages() - 1);
                ReportDashboardPanel.this.broadcastPageChangedEvent(target);
            }
        }.add(new Behavior[]{AttributeAppender.append((String)"class", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                return ReportDashboardPanel.this.pageNum == ReportDashboardPanel.this.totalPages() - 1 ? "disabled" : "";
            }
        })})});
        span.add(new Component[]{new AjaxLink<Void>("firstPage"){

            public void onClick(AjaxRequestTarget target) {
                ReportDashboardPanel.this.pageNum = 0;
                ReportDashboardPanel.this.broadcastPageChangedEvent(target);
            }
        }.add(new Behavior[]{AttributeAppender.append((String)"class", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                return ReportDashboardPanel.this.pageNum == 0 ? "disabled" : "";
            }
        })})});
        span.add(new Component[]{new AjaxLink<Void>("lastPage"){

            public void onClick(AjaxRequestTarget target) {
                ReportDashboardPanel.this.pageNum = ReportDashboardPanel.this.totalPages() - 1;
                ReportDashboardPanel.this.broadcastPageChangedEvent(target);
            }
        }.add(new Behavior[]{AttributeAppender.append((String)"class", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                return ReportDashboardPanel.this.pageNum == ReportDashboardPanel.this.totalPages() - 1 ? "disabled" : "";
            }
        })})});
        span.setVisibilityAllowed(10 < this.getReportSets().length);
        return span;
    }

    private void broadcastPageChangedEvent(AjaxRequestTarget target) {
        this.send((IEventSink)this, Broadcast.BREADTH, new DashboardPageChanged(target, this.pageNum));
    }

    protected int getFrom() {
        int from = 10 * this.pageNum;
        String[] reportsets = this.getReportSets();
        return from > reportsets.length - 1 ? reportsets.length - 1 : from;
    }

    protected int getTo() {
        int to = (this.pageNum + 1) * 10 - 1;
        String[] reportsets = this.getReportSets();
        if (to > reportsets.length - 1) {
            to = reportsets.length - 1;
        }
        return to;
    }

    private int totalPages() {
        String[] reportsets = this.getReportSets();
        if (reportsets.length == 0) {
            return 0;
        }
        if (reportsets.length % 10 == 0) {
            return reportsets.length / 10;
        }
        return reportsets.length / 10 + 1;
    }

    protected AbstractDashboardModulePanel createModulePanel(DashboardModule module, IModel<RendererContext> model) {
        return module.createModulePanel(model);
    }

    protected RendererContext getContext() {
        return (RendererContext)this.getDefaultModelObject();
    }

    protected String[] getReportSets() {
        return (String[])Iterables.toArray((Iterable)((Iterable)this.reportsetModel.getObject()), String.class);
    }

    protected Build getBuild() {
        return Context.getBuild();
    }

    public void onEvent(IEvent<?> sink) {
        if (sink.getPayload() instanceof DashboardPageChanged) {
            DashboardPageChanged event = (DashboardPageChanged)sink.getPayload();
            this.pageNum = event.getPage();
            event.getTarget().add(new Component[]{this.get("span")});
        }
    }

    protected void onDetach() {
        super.onDetach();
        if (this.reportsetModel != null) {
            this.reportsetModel.detach();
        }
    }
}

