/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.dashboard;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererMode;
import com.pmease.quickbuild.plugin.report.engine.renderer.dashboard.DashboardModule;
import com.pmease.quickbuild.plugin.report.engine.renderer.dashboard.ReportDashboardPanel;
import com.pmease.quickbuild.plugin.report.engine.util.TypedObjects;
import java.util.List;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.dom4j.Element;

public class DashboardRenderer
extends AbstractRenderer {
    private static final long serialVersionUID = 1L;
    public static DashboardRenderer NULL_RENDERER = new DashboardRenderer(ReportCategory.NULL_CATEGORY);
    private List<DashboardModule> modules = Lists.newArrayList();
    private boolean paging = true;

    public DashboardRenderer(ReportCategory category) {
        super(category);
        this.setMode(RendererMode.DASHBOARD);
        this.setContentOnly(true);
    }

    @Override
    public String getType() {
        return "DASHBOARD";
    }

    @Override
    public Panel createReportPanel(String id, IModel<RendererContext> model) {
        return new ReportDashboardPanel(id, this, model);
    }

    @Override
    public boolean isApplicable() {
        if (this.modules.isEmpty()) {
            return false;
        }
        for (DashboardModule each : this.modules) {
            if (each.getRenderer().isApplicable()) continue;
            return false;
        }
        String[] names = this.category.getReportSetsOfBuild(Context.getBuild());
        return names.length > 0;
    }

    @Override
    public void fromXML(Element node) {
        super.fromXML(node);
        List nodes = node.elements("module");
        for (Element each : nodes) {
            DashboardModule module = TypedObjects.createTypedObject(each, DashboardModule.class, new DashboardModule(this), this);
            module.fromXML(each);
            this.addModule(module);
        }
    }

    public List<DashboardModule> getModules() {
        return this.modules;
    }

    public void setModules(List<DashboardModule> modules) {
        this.modules = modules;
    }

    public void addModule(DashboardModule module) {
        this.modules.add(module);
    }

    public boolean isPaging() {
        return this.paging;
    }

    public void setPaging(boolean paging) {
        this.paging = paging;
    }
}

