/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.dashboard;

import com.google.common.base.Strings;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.SessionData;
import com.pmease.quickbuild.plugin.report.engine.renderer.dashboard.DashboardModule;
import com.pmease.quickbuild.plugin.report.engine.web.LinkPanel;
import com.pmease.quickbuild.web.component.dashboardpanel.BaseDashboardModulePanel;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import com.pmease.quickbuild.web.page.build.BuildPage;
import java.util.HashMap;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class DashboardModulePanel
extends BaseDashboardModulePanel {
    private static final long serialVersionUID = 1L;
    final DashboardModule module;

    public DashboardModulePanel(DashboardModule module, IModel<RendererContext> model) {
        super(model);
        this.module = module;
    }

    public String getReportSet() {
        RendererContext context = (RendererContext)this.getDefaultModelObject();
        return context.getReportSet();
    }

    protected Component getTitleComponent(String id) {
        if (Strings.isNullOrEmpty((String)this.module.getTitle())) {
            return new WebMarkupContainer(id).setVisible(false);
        }
        String title = this.module.getTitle();
        if (!"DEFAULT".equalsIgnoreCase(this.getReportSet())) {
            title = title + " (" + this.getReportSet() + ")";
        }
        return new Label(id, title);
    }

    public RendererContext getContext() {
        return (RendererContext)this.getDefaultModelObject();
    }

    protected Component getContentComponent(String id) {
        return this.module.getRenderer().createReportPanel(id, (IModel<RendererContext>)this.getDefaultModel());
    }

    protected String getContentExtraCss() {
        return this.module.getCss();
    }

    protected Component getFooterComponent(String id) {
        String toTab = this.module.getToTab();
        String toUrl = this.module.getToUrl();
        if (!Strings.isNullOrEmpty((String)toTab)) {
            return new LinkPanel(id, "View Report", true){
                private static final long serialVersionUID = 1L;

                @Override
                protected AbstractLink createLink(String id) {
                    return new Link<Void>(id){
                        private static final long serialVersionUID = 1L;

                        public void onClick() {
                            SessionData.get().setFilter(null);
                            SessionData.get().setCategoryId(DashboardModulePanel.this.module.getRenderer().getCategory().getId());
                            PageParameters params = BuildPage.params4((Long)DashboardModulePanel.this.getBuild().getId(), (String[])new String[]{Tab.title2id((String)DashboardModulePanel.this.module.getCategory().getName()), Tab.title2id((String)DashboardModulePanel.this.module.getToTab())});
                            params.add("reportset", (Object)DashboardModulePanel.this.getReportSet());
                            this.setResponsePage(BuildPage.class, params);
                        }
                    };
                }
            };
        }
        if (!Strings.isNullOrEmpty((String)toUrl)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Build build = this.getBuild();
            map.put("build", build);
            map.put("configuration", build.getConfiguration());
            String url = ReportHelper.interpolate(toUrl, map);
            StringBuffer sb = new StringBuffer();
            sb.append("<a href='").append(url).append("'>View Report").append("</a>");
            return new Label(id, sb.toString()).setEscapeModelStrings(false);
        }
        return null;
    }

    protected Build getBuild() {
        return Context.getBuild();
    }
}

