/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.dashboard;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.ReportDataSource;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractReportPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererMode;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class AbstractDashboardStatsPanel
extends AbstractReportPanel {
    private static final long serialVersionUID = 1L;
    protected IModel<ItemContext> contextModel = new LoadableDetachableModel<ItemContext>(){
        private static final long serialVersionUID = 1L;

        protected ItemContext load() {
            return AbstractDashboardStatsPanel.this.createItemContext();
        }
    };

    public AbstractDashboardStatsPanel(String id, AbstractRenderer renderer, IModel<RendererContext> model) {
        super(id, renderer, model);
    }

    protected boolean isCalcStats() {
        return this.getRenderer().getMode() == RendererMode.AGGREGATION_OVERVIEW;
    }

    protected boolean isLoadPrevious() {
        return this.getRenderer().getMode() != RendererMode.AGGREGATION_OVERVIEW;
    }

    protected ItemContext createItemContext() {
        ItemContext context = new ItemContext();
        context.setReportPanel(this);
        DataReport report = this.isCalcStats() ? this.getReportStats() : this.getDefaultReport();
        DataRow row = report.isEmpty() ? new DataRow(report) : report.getRow(0);
        context.setDataRow(row);
        Map<String, Object> expContext = row.toMap();
        if (this.isLoadPrevious()) {
            Map<String, Object> previousStats = this.getPreviousStats();
            expContext.put("previous", previousStats);
            context.setPrevStats(previousStats);
        }
        expContext.put("utils", ReportUtils.getInstance());
        expContext.putAll(this.buildContext());
        context.setExpressionContext(expContext);
        context.setBuild(this.getBuild());
        context.setConfiguration(this.getConfiguration());
        context.setReportSet(this.getReportSet());
        return context;
    }

    protected Map<String, Object> buildContext() {
        return Collections.emptyMap();
    }

    protected ItemContext getItemContext() {
        return (ItemContext)this.contextModel.getObject();
    }

    protected Map<String, Object> getPreviousStats() {
        if (!ReportHelper.isShowReports(this.renderer.getCategory())) {
            return Collections.emptyMap();
        }
        Build build = this.getBuild();
        BuildManager bm = (BuildManager)Quickbuild.getInstance(BuildManager.class);
        Build previous = bm.getPreviousFinished(build);
        if (previous == null) {
            return Collections.emptyMap();
        }
        AbstractRenderer r = this.getRenderer();
        ReportCategory category = r.getCategory();
        File dbDir = category.getReportDirOfBuild(previous, this.getReportSet());
        if (!dbDir.exists()) {
            return Collections.emptyMap();
        }
        ReportDataSource rds = r.getDataSource();
        DataReport report = category.loadReport(dbDir, rds);
        if (report.isEmpty()) {
            return Collections.emptyMap();
        }
        DataRow row = report.getRow(0);
        return row.toMap();
    }

    public IModel<ItemContext> getContextModel() {
        return this.contextModel;
    }

    @Override
    public void onDetach() {
        if (this.contextModel != null) {
            this.contextModel.detach();
        }
        super.onDetach();
    }
}

