/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.composite;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractReportPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.composite.CompositeRenderer;
import com.pmease.quickbuild.plugin.report.engine.web.jquery.JQLazyLoadTabbedPanel;
import com.pmease.quickbuild.plugin.report.engine.web.jquery.JQTabbedPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class CompositeTabbedPanel
extends AbstractReportPanel {
    private static final long serialVersionUID = 1L;

    public CompositeTabbedPanel(String id, CompositeRenderer renderer, IModel<RendererContext> model) {
        super(id, renderer, model);
        if (renderer.isLazyload()) {
            this.add(new Component[]{new JQLazyLoadTabbedPanel("tabbedPanel", this.getTabs())});
        } else {
            this.add(new Component[]{new JQTabbedPanel("tabbedPanel", this.getTabs())});
        }
    }

    protected List<ITab> getTabs() {
        ArrayList tabs = Lists.newArrayList();
        for (AbstractRenderer renderer : this.getRenderer().getSubRenderers()) {
            if (!renderer.isApplicable()) continue;
            tabs.add(new ChildTab(renderer));
        }
        return tabs;
    }

    @Override
    public DataReport getDefaultReport() {
        JQLazyLoadTabbedPanel panel;
        Component c;
        Panel tabbed = (Panel)this.get("tabbedPanel");
        if (tabbed instanceof JQLazyLoadTabbedPanel && (c = (panel = (JQLazyLoadTabbedPanel)tabbed).getActivePanel()) != null && c instanceof AbstractReportPanel) {
            AbstractReportPanel reportPanel = (AbstractReportPanel)c;
            return reportPanel.getDefaultReport();
        }
        return null;
    }

    @Override
    public CompositeRenderer getRenderer() {
        return (CompositeRenderer)super.getRenderer();
    }

    private class ChildTab
    implements ITab {
        private static final long serialVersionUID = 1L;
        private final AbstractRenderer renderer;

        public ChildTab(AbstractRenderer renderer) {
            this.renderer = renderer;
        }

        public Panel getPanel(String panelId) {
            RendererContext newContext = new RendererContext(CompositeTabbedPanel.this.getContext());
            newContext.setReportSet(CompositeTabbedPanel.this.getReportSet());
            Panel panel = this.renderer.createReportPanel(panelId, (IModel<RendererContext>)Model.of((Serializable)newContext));
            if (!Strings.isNullOrEmpty((String)this.renderer.getCss())) {
                panel.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)this.renderer.getCss())), " ")});
            }
            return panel;
        }

        public IModel<String> getTitle() {
            return Model.of((Serializable)((Object)this.renderer.getTitle()));
        }

        public boolean isVisible() {
            return true;
        }
    }
}

