/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.composite;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.composite.CompositeReportPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.composite.CompositeTabbedPanel;
import com.pmease.quickbuild.plugin.report.engine.util.TypedObjects;
import java.util.List;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.dom4j.Element;

public class CompositeRenderer
extends AbstractRenderer {
    private static final long serialVersionUID = 1L;
    @Alias
    private boolean useTab = true;
    protected List<AbstractRenderer> subRenderers = Lists.newArrayList();

    public CompositeRenderer(ReportCategory category) {
        super(category);
        this.setLazyload(true);
    }

    @Override
    public String getType() {
        return "COMPOSITE";
    }

    @Override
    public Panel createReportPanel(String id, IModel<RendererContext> model) {
        if (this.isUseTab()) {
            return new CompositeTabbedPanel(id, this, model);
        }
        return new CompositeReportPanel(id, this, model);
    }

    @Override
    public void fromXML(Element node) {
        super.fromXML(node);
        List nodes = node.elements("renderer");
        for (Element each : nodes) {
            AbstractRenderer renderer = TypedObjects.createTypedObject(each, AbstractRenderer.class, null, this.category);
            renderer.setMode(this.getMode());
            renderer.fromXML(each);
            if (renderer.getDataSource() == null) {
                renderer.setDataSource(this.getDataSource());
            }
            renderer.setParentRenderer(this);
            this.addRenderer(renderer);
        }
    }

    public void addRenderer(AbstractRenderer renderer) {
        renderer.setMode(this.getMode());
        this.subRenderers.add(renderer);
    }

    public List<AbstractRenderer> getSubRenderers() {
        return this.subRenderers;
    }

    public void setSubRenderers(List<AbstractRenderer> subRenderers) {
        this.subRenderers = subRenderers;
    }

    public boolean isUseTab() {
        return this.useTab;
    }

    public void setUseTab(boolean useTab) {
        this.useTab = useTab;
    }
}

