/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.chart.pie;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.web.chart.ChartUtils;
import com.pmease.quickbuild.web.chart.JFreeChartPanel;
import com.pmease.quickbuild.web.component.dashboardpanel.StatsData;
import java.awt.Color;
import java.awt.Paint;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class PieChartPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private final String noDataMessage;

    public PieChartPanel(String id, int width, int height, IModel<List<StatsData>> model) {
        this(id, width, height, null, true, model);
    }

    public PieChartPanel(String id, int width, int height, String noDataMessage, boolean withLegend, IModel<List<StatsData>> model) {
        super(id, model);
        this.noDataMessage = noDataMessage;
        this.add(new Component[]{new JFreeChartPanel("pieChart", width, height, (IModel)new PieChartModel())});
        if (withLegend) {
            this.addLegends();
        } else {
            this.add(new Component[]{new WebMarkupContainer("legends").setVisible(false)});
        }
    }

    protected List<StatsData> getChartData() {
        return (List)this.getDefaultModelObject();
    }

    private PieDataset getDataset() {
        DefaultPieDataset dataset = new DefaultPieDataset();
        List<StatsData> data = this.getChartData();
        for (StatsData datum : data) {
            try {
                dataset.setValue((Comparable)((Object)datum.getTitle()), ((Number)datum.getValue()).doubleValue());
            }
            catch (Exception e) {
                dataset.setValue((Comparable)((Object)datum.getTitle()), 0.0);
            }
        }
        return dataset;
    }

    protected String formatLegend(StatsData data) {
        List<StatsData> all = this.getChartData();
        double totals = 0.0;
        for (StatsData datum : all) {
            totals += ((Number)datum.getValue()).doubleValue();
        }
        double percent = totals == 0.0 ? 0.0 : new BigDecimal(data.getValue().toString()).doubleValue() / totals;
        String result = data.formatData();
        result = result + " (" + DataTypes.PERCENT.asString(percent, "0.00%") + ")";
        return result;
    }

    private void addLegends() {
        ListView<StatsData> legendsView = new ListView<StatsData>("legends", this.getDefaultModel()){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<StatsData> item) {
                StatsData data = (StatsData)item.getModelObject();
                WebMarkupContainer colorContainer = new WebMarkupContainer("legendColor");
                colorContainer.add(new Behavior[]{new AttributeAppender("style", (IModel)Model.of((Serializable)((Object)("background: " + data.getColor()))), " ")});
                item.add(new Component[]{colorContainer});
                item.add(new Component[]{new Label("legendTitle", data.getTitle())});
                item.add(new Component[]{new Label("legendData", PieChartPanel.this.formatLegend(data))});
            }
        };
        this.add(new Component[]{legendsView});
    }

    private class PieChartModel
    extends LoadableDetachableModel<JFreeChart> {
        private static final long serialVersionUID = 1L;

        private PieChartModel() {
        }

        protected JFreeChart load() {
            JFreeChart chart = ChartFactory.createPieChart((String)"", (PieDataset)PieChartPanel.this.getDataset(), (boolean)false, (boolean)true, (boolean)false);
            chart.setBackgroundPaint((Paint)Color.WHITE);
            PiePlot plot = (PiePlot)chart.getPlot();
            ChartUtils.initDefaultPieChart((PiePlot)plot);
            List<StatsData> data = PieChartPanel.this.getChartData();
            for (StatsData datum : data) {
                plot.setSectionPaint((Comparable)((Object)datum.getTitle()), (Paint)datum.getAWTColor());
            }
            if (!Strings.isNullOrEmpty((String)PieChartPanel.this.noDataMessage)) {
                plot.setNoDataMessage(PieChartPanel.this.noDataMessage);
            }
            return chart;
        }
    }
}

