/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.chart.line;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datatype.BooleanType;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.datatype.EnumType;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.XMLSerializable;
import com.pmease.quickbuild.plugin.report.engine.renderer.LineChartOption;
import com.pmease.quickbuild.plugin.report.engine.renderer.chart.line.LineChartItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.chart.line.LineChartSetting;
import com.pmease.quickbuild.plugin.report.engine.util.BuildFragment;
import com.pmease.quickbuild.plugin.report.engine.util.Builds;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.util.DateRange;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.joda.time.MutableDateTime;

public class LineChartData
implements XMLSerializable {
    private static final long serialVersionUID = 1L;
    protected final LineChartSetting setting;
    protected final LineChartOption chartOption;
    protected List<LineChartItem> items = Lists.newArrayList();
    protected double max = 0.0;
    protected double min = Double.MAX_VALUE;
    protected double periodMax = 0.0;
    protected double periodMin = 0.0;
    protected double totals = 0.0;
    protected int succeeded = 0;
    protected int failed = 0;
    protected int totalBuilds = 0;
    protected int validBuilds = 0;

    public LineChartData(LineChartSetting setting, LineChartOption chartOption) {
        this.setting = setting;
        this.chartOption = chartOption;
    }

    public List<LineChartItem> getItems() {
        return this.items;
    }

    public LineChartItem getItem(int index) {
        return this.items.get(index);
    }

    public int size() {
        return this.items.size();
    }

    public double getAverage() {
        if (this.validBuilds == 0) {
            return 0.0;
        }
        return this.totals / (double)this.validBuilds;
    }

    public String getSummaryInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("Max: ").append(this.getDataType().asString(this.getMax())).append(", Min: ").append(this.getDataType().asString(this.getMin()));
        if (this.validBuilds > 0) {
            sb.append(" in ").append(this.validBuilds).append(" valid builds");
        }
        return sb.toString();
    }

    public void addItem(LineChartItem item) {
        this.totalBuilds += item.getTotalBuilds();
        this.validBuilds += item.getValidBuilds();
        this.failed += item.getFailed();
        this.succeeded += item.getSucceeded();
        this.items.add(item);
    }

    public void build(DataReport report, Builds builds) {
        Preconditions.checkNotNull((Object)this.chartOption, (Object)"ChartOption should be set before build chart data");
        Preconditions.checkNotNull((Object)this.setting, (Object)"ChartSetting should be set before build chart data");
        Preconditions.checkNotNull((Object)report, (Object)"Report should not be null");
        String columnName = this.setting.getItem().getValueExpression();
        if (!report.getMeta().hasColumn(columnName)) {
            return;
        }
        switch (this.chartOption.getGroupOption()) {
            case BY_VERSION: {
                this.groupByVersion(report, builds);
                break;
            }
            default: {
                this.groupByDate(report, builds);
            }
        }
    }

    private DataRow findRow(Long buildId, DataReport report, IndexTracker tracker) {
        if (report.isEmpty()) {
            return null;
        }
        DataRow row = (DataRow)Iterables.getFirst(report.getRows(), null);
        Long startId = row.getLong("buildId");
        row = (DataRow)Iterables.getLast(report.getRows());
        Long endId = row.getLong("buildId");
        if (startId > buildId || endId < buildId) {
            return null;
        }
        for (int i = tracker.nextRow; i < report.getRowsCount(); ++i) {
            row = report.getRow(i);
            Long idInRow = row.getLong("buildId");
            if (Objects.equal((Object)buildId, (Object)idInRow)) {
                ++tracker.nextRow;
                return row;
            }
            if (idInRow > buildId) break;
        }
        return null;
    }

    protected void groupByVersion(DataReport report, Builds builds) {
        if (report.isEmpty()) {
            return;
        }
        String columnName = this.setting.getItem().getValueExpression();
        IndexTracker tracker = new IndexTracker();
        for (BuildFragment each : builds) {
            LineChartItem item = new LineChartItem();
            DataRow row = this.findRow(each.getId(), report, tracker);
            double value = 0.0;
            boolean hasData = false;
            if (row != null) {
                value = row.getDouble(columnName);
                hasData = true;
            }
            if (hasData) {
                boolean passed;
                this.max = Math.max(this.max, value);
                this.min = Math.min(this.min, value);
                this.periodMax = Math.max(this.periodMax, value);
                this.periodMin = Math.min(this.periodMin, value);
                item.setValidBuilds(1);
                boolean bl = passed = each.getStatus() == Build.Status.SUCCESSFUL || each.getStatus() == Build.Status.RECOMMENDED;
                if (passed) {
                    item.setSucceeded(1);
                } else {
                    item.setFailed(1);
                }
            }
            this.totals += value;
            item.setMax(value);
            item.setMin(value);
            item.setValue(value);
            item.setFromBuild(each);
            item.setToBuild(each);
            item.setTotalBuilds(1);
            DateRange dateRange = new DateRange(each.getBeginDate(), each.getBeginDate());
            item.setDateRange(dateRange);
            this.addItem(item);
        }
    }

    protected int getIntervalCount(DateRange dateRange) {
        switch (this.chartOption.getGroupOption()) {
            case BY_DAY: {
                return dateRange.days();
            }
            case BY_WEEK: {
                return dateRange.weeks();
            }
            case BY_MONTH: {
                return dateRange.months();
            }
        }
        throw new IllegalArgumentException("Group option " + (Object)((Object)this.chartOption.getGroupOption()) + " is invalid.");
    }

    static Date truncToDay(Date date) {
        return DateUtils.truncate((Date)date, (int)5);
    }

    protected Builds findPeriodBuilds(Builds builds, DateRange dateRange, IndexTracker tracker) {
        Builds periodBuilds = new Builds();
        if (builds.isEmpty()) {
            return periodBuilds;
        }
        for (int i = tracker.nextBuild; i < builds.size(); ++i) {
            BuildFragment b = (BuildFragment)builds.get(i);
            if (dateRange.contains(b.getBeginDate(), 5)) {
                periodBuilds.add(b);
                ++tracker.nextBuild;
            }
            if (LineChartData.truncToDay(b.getBeginDate()).after(LineChartData.truncToDay(dateRange.getEndDate()))) break;
        }
        return periodBuilds;
    }

    private static BuildFragment findBuild(Builds list, Long id) {
        if (!ReportUtils.isBuildIdValid(id) || list.isEmpty()) {
            return null;
        }
        if (id < list.getFrom().getId() || id > list.getTo().getId()) {
            return null;
        }
        return list.getBuild(id);
    }

    protected PeriodData findPeriodData(Builds builds, DataReport report, DateRange dateRange, IndexTracker tracker) {
        PeriodData data = new PeriodData();
        data.periodBuilds = this.findPeriodBuilds(builds, dateRange, tracker);
        if (data.periodBuilds.isEmpty()) {
            return data;
        }
        List<DataRow> rows = report.getRows();
        long lastBuildId = builds.getTo().getId();
        for (int i = tracker.nextRow; i < rows.size(); ++i) {
            DataRow row = rows.get(i);
            Long buildId = row.getLong("buildId");
            BuildFragment build = LineChartData.findBuild(data.periodBuilds, buildId);
            if (build != null) {
                data.validBuilds.add(build);
                data.rows.add(row);
                ++tracker.nextRow;
            }
            if (buildId > lastBuildId) break;
        }
        return data;
    }

    protected void groupByDate(DataReport report, Builds builds) {
        DateRange dateRange = this.setting.getDateRange();
        int count = this.getIntervalCount(dateRange);
        String columnName = this.setting.getItem().getValueExpression();
        IndexTracker tracker = new IndexTracker();
        for (int i = 0; i <= count; ++i) {
            LineChartItem item = new LineChartItem();
            DateRange currentRange = this.getCurrentRange(dateRange.getBeginDate(), i, count);
            item.setDateRange(currentRange);
            PeriodData data = this.findPeriodData(builds, report, currentRange, tracker);
            item.setTotalBuilds(data.periodBuilds.size());
            item.setValidBuilds(data.validBuilds.size());
            item.setSucceeded(data.periodBuilds.getSuccesses());
            item.setFailed(data.periodBuilds.getFailed());
            item.setFromBuild(data.periodBuilds.getFrom());
            item.setToBuild(data.periodBuilds.getTo());
            List<DataRow> periodRows = data.rows;
            double periodMax = 0.0;
            double periodMin = Double.MAX_VALUE;
            double periodTotals = 0.0;
            for (DataRow each : periodRows) {
                double value = each.getDouble(columnName);
                periodMax = Math.max(periodMax, value);
                periodMin = Math.min(periodMin, value);
                periodTotals += value;
            }
            this.totals += periodTotals;
            double periodValue = this.setting.getItem().isUseAverage() ? (item.getValidBuilds() == 0 ? 0.0 : periodTotals / (double)item.getValidBuilds()) : periodTotals;
            if (periodRows.size() > 0) {
                if (this.setting.getItem().isUseAverage()) {
                    this.max = Math.max(this.max, periodValue);
                    this.min = Math.min(this.min, periodValue);
                } else {
                    this.max = Math.max(this.max, periodMax);
                    this.min = Math.min(this.min, periodMin);
                }
                this.periodMax = Math.max(this.periodMax, periodValue);
                this.periodMin = Math.min(this.periodMin, periodValue);
            }
            item.setValue(periodValue);
            item.setMax(periodMax);
            item.setMin(periodMin);
            this.addItem(item);
        }
    }

    protected DateRange getCurrentRange(Date beginDate, int i, int count) {
        MutableDateTime day = new MutableDateTime((Object)beginDate);
        switch (this.chartOption.getGroupOption()) {
            case BY_DAY: {
                day.addDays(i);
                return new DateRange(day.toDate(), day.toDate());
            }
            case BY_WEEK: {
                day.addWeeks(i);
                if (i == 0) {
                    MutableDateTime sunday = new MutableDateTime((Object)day);
                    sunday.setDayOfWeek(7);
                    return new DateRange(day.toDate(), sunday.toDate());
                }
                if (i == count) {
                    MutableDateTime monday = new MutableDateTime((Object)day);
                    monday.setDayOfWeek(1);
                    return new DateRange(monday.toDate(), this.setting.getDateRange().getEndDate());
                }
                return DateRange.weekOfDay((Date)day.toDate());
            }
            case BY_MONTH: {
                day.addMonths(i);
                if (i == 0) {
                    MutableDateTime lastDay = new MutableDateTime((Object)day);
                    lastDay.setDayOfMonth(lastDay.dayOfMonth().getMaximumValue());
                    return new DateRange(day.toDate(), lastDay.toDate());
                }
                if (i == count) {
                    MutableDateTime firstDay = new MutableDateTime((Object)day);
                    firstDay.setDayOfMonth(firstDay.dayOfMonth().getMinimumValue());
                    return new DateRange(firstDay.toDate(), this.setting.getDateRange().getEndDate());
                }
                return DateRange.monthOfDay((Date)day.toDate());
            }
        }
        throw new IllegalArgumentException("Group option is invalid.");
    }

    public String getLabel(int index) {
        LineChartItem item = this.getItem(index);
        switch (this.chartOption.getGroupOption()) {
            case BY_VERSION: {
                return item.getFromBuild().getVersion();
            }
            case BY_DAY: {
                return DataTypes.DATE.asString(item.getDateRange().getBeginDate(), "MMM dd");
            }
        }
        return item.getDateRange().toShortString();
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double getMin() {
        if (this.min >= Double.MAX_VALUE) {
            return 0.0;
        }
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getPeriodMax() {
        if (this.min >= Double.MAX_VALUE) {
            return 0.0;
        }
        return this.periodMax;
    }

    public void setPeriodMax(double periodMax) {
        this.periodMax = periodMax;
    }

    public double getPeriodMin() {
        return this.periodMin;
    }

    public void setPeriodMin(double periodMin) {
        this.periodMin = periodMin;
    }

    public double getTotals() {
        return this.totals;
    }

    public void setTotals(double totals) {
        this.totals = totals;
    }

    public int getSucceeded() {
        return this.succeeded;
    }

    public void setSucceeded(int succeeded) {
        this.succeeded = succeeded;
    }

    public int getFailed() {
        return this.failed;
    }

    public void setFailed(int failed) {
        this.failed = failed;
    }

    public int getTotalBuilds() {
        return this.totalBuilds;
    }

    public void setTotalBuilds(int totalBuilds) {
        this.totalBuilds = totalBuilds;
    }

    public int getValidBuilds() {
        return this.validBuilds;
    }

    public void setValidBuilds(int validBuilds) {
        this.validBuilds = validBuilds;
    }

    public DataType getDataType() {
        DataType dataType = this.setting.getItem().getDataType();
        if (dataType instanceof BooleanType || dataType instanceof EnumType) {
            return DataTypes.PERCENT;
        }
        return dataType;
    }

    public LineChartSetting getSetting() {
        return this.setting;
    }

    public LineChartOption getChartOption() {
        return this.chartOption;
    }

    public void setItems(List<LineChartItem> items) {
        this.items = items;
    }

    @Override
    public void fromXML(Element node) {
    }

    @Override
    public Element toXML() {
        Element node = DocumentHelper.createElement((String)"series");
        node.addAttribute("title", this.setting.getTitle());
        node.addAttribute("max", String.valueOf(this.max));
        if (this.min < Double.MAX_VALUE) {
            node.addAttribute("min", String.valueOf(this.min));
        }
        for (LineChartItem each : this.items) {
            node.add(each.toXML());
        }
        return node;
    }

    public static class IndexTracker {
        public int nextBuild = 0;
        public int nextRow = 0;
    }

    protected class PeriodData {
        public Builds periodBuilds = new Builds();
        public Builds validBuilds = new Builds();
        public List<DataRow> rows = Lists.newArrayList();
    }

    static class BuildIdPredicate
    implements Predicate<DataRow> {
        final Long buildId;

        public BuildIdPredicate(Long buildId) {
            this.buildId = buildId;
        }

        public boolean apply(DataRow input) {
            Long buildId = input.getLong("buildId");
            return this.buildId.equals(buildId);
        }
    }
}

