/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.chart.line;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pmease.quickbuild.plugin.report.engine.datatype.BooleanType;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.datatype.DurationType;
import com.pmease.quickbuild.plugin.report.engine.datatype.PercentType;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.XMLSerializable;
import com.pmease.quickbuild.plugin.report.engine.renderer.CompareOption;
import com.pmease.quickbuild.plugin.report.engine.renderer.GroupOption;
import com.pmease.quickbuild.plugin.report.engine.renderer.LineChartOption;
import com.pmease.quickbuild.plugin.report.engine.renderer.SessionData;
import com.pmease.quickbuild.plugin.report.engine.renderer.chart.line.LineChartData;
import com.pmease.quickbuild.plugin.report.engine.renderer.chart.line.LineChartItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.chart.line.Range;
import com.pmease.quickbuild.plugin.report.engine.util.BuildFragment;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.util.DateRange;
import com.pmease.quickbuild.web.chart.ChartUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.velocity.runtime.parser.node.MathUtils;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.joda.time.DateTime;

public class LineChart
implements XMLSerializable {
    private static final long serialVersionUID = 1L;
    private final List<LineChartData> chartSeries;
    private final LineChartOption chartOption;
    private int lower = 0;
    private int steps = 0;
    private int maxRows = 0;
    private List<Map<Integer, Integer>> itemRowIndexMap = Lists.newArrayList();
    private Map<DataType, Range> rangeMap = Maps.newHashMap();
    private final boolean showBuildInfo;

    public LineChart(List<LineChartData> chartSeries, boolean showBuildInfo, LineChartOption chartOption) {
        this.chartSeries = chartSeries;
        this.chartOption = chartOption;
        this.showBuildInfo = showBuildInfo;
        this.initialize();
    }

    protected void initialize() {
        for (LineChartData each : this.chartSeries) {
            this.maxRows = Math.max(each.size(), this.maxRows);
            this.itemRowIndexMap.add(new HashMap());
            Range range = this.rangeMap.get(each.getDataType());
            if (range == null) {
                range = new Range(Double.MAX_VALUE, 0.0);
                this.rangeMap.put(each.getDataType(), range);
            }
            range.setMin(Math.min(range.getMin(), each.getPeriodMin()));
            range.setMax(Math.max(range.getMax(), each.getPeriodMax()));
        }
        DateRange dateRange = this.chartOption.getPrimaryDateRange();
        if (this.maxRows <= 5) {
            this.steps = 1;
        } else if (this.chartOption.getGroupOption() == GroupOption.BY_DAY) {
            this.lower = new DateTime((Object)dateRange.getBeginDate()).getDayOfWeek() - 1;
            int weeks = dateRange.weeks();
            this.steps = weeks <= 5 ? 7 : (weeks / 5 + 1) * 7;
        } else {
            int m = this.maxRows % 5;
            this.lower = m / 2;
            this.steps = this.maxRows / 5;
        }
    }

    public int size() {
        return this.chartSeries.size();
    }

    public JFreeChart getChart() {
        if (this.chartSeries.isEmpty()) {
            return null;
        }
        Plot plot = this.getPlot();
        if (plot == null) {
            return null;
        }
        JFreeChart chart = new JFreeChart(null, null, plot, false);
        this.customizeChart(chart);
        return chart;
    }

    protected void customizeChart(JFreeChart chart) {
        chart.setBackgroundPaint((Paint)Color.WHITE);
    }

    protected Plot getPlot() {
        XYPlot plot = new XYPlot();
        plot.setBackgroundAlpha(0.5f);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setNoDataMessage("No Data Available");
        plot.setDomainGridlinesVisible(true);
        plot.setRangeGridlinesVisible(true);
        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        plot.setOutlineVisible(false);
        plot.setDomainZeroBaselineVisible(false);
        this.createXAxis(plot);
        this.createYAxes(plot);
        for (int i = 0; i < this.chartSeries.size(); ++i) {
            plot.setDataset(i, this.toDataset(i));
        }
        plot.mapDatasetToDomainAxis(0, 0);
        return plot;
    }

    public XYDataset toDataset(int index) {
        LineChartData data = this.chartSeries.get(index);
        XYSeries series = new XYSeries((Comparable)((Object)data.getSetting().getTitle()));
        boolean ignoreNoBuildDays = this.chartOption.isIgnoreNoBuildDays();
        int itemIndex = 0;
        Map<Integer, Integer> map = this.itemRowIndexMap.get(index);
        for (int i = 0; i < this.maxRows && i < data.size(); ++i) {
            LineChartItem item = data.getItem(i);
            int builds = item.getTotalBuilds();
            if (builds == 0 && ignoreNoBuildDays) continue;
            series.add((double)(i + this.lower), item.getValue());
            map.put(itemIndex++, i);
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series);
        return dataset;
    }

    protected void createXAxis(XYPlot plot) {
        NumberAxis xaxis = new NumberAxis("");
        xaxis.setAxisLineVisible(true);
        if (this.maxRows > 1) {
            xaxis.setRangeWithMargins((double)this.lower, (double)(this.maxRows + this.lower - 1));
        }
        xaxis.setTickUnit((NumberTickUnit)new DomainTickUnit(this.steps));
        xaxis.setTickMarksVisible(true);
        xaxis.setAxisLineVisible(false);
        xaxis.setTickLabelPaint((Paint)new Color(102, 102, 102));
        plot.setDomainAxis(0, (ValueAxis)xaxis);
    }

    protected String domainValueToString(double value) {
        LineChartData data = this.chartSeries.get(0);
        int index = new Double(value - (double)this.lower).intValue();
        if (index < 0 || index >= data.size()) {
            return "";
        }
        return data.getLabel(index);
    }

    protected void createYAxes(XYPlot plot) {
        LineGroup g;
        HashMap<DataType, LineGroup> groups = new HashMap<DataType, LineGroup>();
        for (int i = 0; i < this.chartSeries.size(); ++i) {
            LineChartData each = this.chartSeries.get(i);
            DataType dataType = each.getDataType();
            LineGroup group = (LineGroup)groups.get(dataType);
            if (group == null) {
                group = new LineGroup();
                group.setNum(0);
                groups.put(dataType, group);
            }
            group.setNum(group.getNum() + 1);
            group.getIndexes().add(i);
        }
        DataType primaryType = this.chartSeries.get(0).getDataType();
        LineGroup group = (LineGroup)groups.get(primaryType);
        group.setAxisIndex(0);
        NumberAxis axis = this.createYAxis(primaryType);
        group.setAxis(axis);
        plot.setRangeAxis(0, (ValueAxis)((LineGroup)groups.get(primaryType)).getAxis());
        DataType secondType = primaryType;
        int maxNumber = 0;
        for (DataType key : groups.keySet()) {
            LineGroup each = (LineGroup)groups.get(key);
            if (Objects.equal((Object)key, (Object)primaryType) || each.getNum() <= maxNumber) continue;
            secondType = key;
        }
        if (!Objects.equal((Object)primaryType, (Object)secondType)) {
            LineGroup g2 = (LineGroup)groups.get(secondType);
            axis = this.createYAxis(secondType);
            g2.setAxis(axis);
            g2.setAxisIndex(1);
            plot.setRangeAxis(1, (ValueAxis)g2.getAxis());
        }
        if (groups.size() > 2) {
            int axisIndex = 2;
            for (DataType key : groups.keySet()) {
                if (Objects.equal((Object)key, (Object)primaryType) || Objects.equal((Object)key, (Object)secondType)) continue;
                g = (LineGroup)groups.get(key);
                axis = this.createYAxis(key);
                axis.setVisible(false);
                g.setAxis(axis);
                g.setAxisIndex(axisIndex);
                plot.setRangeAxis(axisIndex, (ValueAxis)axis);
                ++axisIndex;
            }
        }
        for (int i = 0; i < this.chartSeries.size(); ++i) {
            LineChartData each = this.chartSeries.get(i);
            DataType dataType = each.getDataType();
            g = (LineGroup)groups.get(dataType);
            plot.mapDatasetToRangeAxis(i, g.getAxisIndex());
            XYLineAndShapeRenderer renderer = this.createRenderer(i);
            plot.setRenderer(i, (XYItemRenderer)renderer);
        }
    }

    protected NumberAxis createYAxis(DataType dataType) {
        NumberAxis axis = new NumberAxis("");
        double actual = this.getRangeUpper(dataType);
        axis.setRangeWithMargins(0.0, actual);
        axis.setAxisLineVisible(false);
        axis.setTickUnit(this.createRangeTickUnit(actual, dataType));
        axis.setTickLabelPaint((Paint)new Color(102, 102, 102));
        return axis;
    }

    protected double getRangeUpper(DataType dataType) {
        Double max = this.rangeMap.get(dataType).getMax();
        if (MathUtils.isZero((Number)max)) {
            max = 1.0;
        }
        if (dataType instanceof BooleanType || dataType instanceof PercentType) {
            return 1.0;
        }
        long l = max.longValue() / 10L;
        if (l < 0L || MathUtils.isZero((Number)l)) {
            return 10.0;
        }
        return (l + 1L) * 10L;
    }

    protected NumberTickUnit createRangeTickUnit(double max, final DataType dataType) {
        return new NumberTickUnit(max / 2.0){
            private static final long serialVersionUID = 1L;

            public String valueToString(double value) {
                if (dataType instanceof BooleanType || dataType instanceof PercentType) {
                    return DataTypes.PERCENT.asString(value, "#%");
                }
                if (dataType instanceof DurationType) {
                    return dataType.asString(value, "HH:mm:ss");
                }
                return dataType.asString(value);
            }
        };
    }

    protected XYLineAndShapeRenderer createRenderer(int index) {
        LineRenderer renderer = new LineRenderer(index);
        this.customizeRenderer(renderer);
        return renderer;
    }

    protected void customizeRenderer(LineRenderer renderer) {
        int index = renderer.getIndex();
        if (index == 0) {
            renderer.setSeriesStroke(0, ChartUtils.getPrimaryStroke());
        } else {
            renderer.setSeriesStroke(0, ChartUtils.getSecondaryStroke());
        }
        if (index < 4) {
            renderer.setSeriesPaint(0, ChartUtils.DEFAULT_COLORS[index]);
            renderer.setSeriesFillPaint(0, ChartUtils.DEFAULT_COLORS[index]);
        }
        if (renderer.isWithShape()) {
            renderer.setUseFillPaint(true);
            renderer.setSeriesShapesVisible(0, true);
            if (index == 0) {
                renderer.setSeriesShape(0, ChartUtils.getPrimaryShape());
            } else {
                renderer.setSeriesShape(0, ChartUtils.getSecondaryShape());
            }
            renderer.setUseOutlinePaint(true);
            renderer.setSeriesOutlineStroke(0, new BasicStroke(1.0f));
            renderer.setSeriesOutlinePaint(0, Color.white);
        } else {
            renderer.setBaseShapesVisible(false);
        }
        renderer.setBaseToolTipGenerator(this.createTooltipGenerator(index));
    }

    private XYToolTipGenerator createTooltipGenerator(int index) {
        return new StatsToolTipGenerator(index);
    }

    public int getLower() {
        return this.lower;
    }

    public int getSteps() {
        return this.steps;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public List<LineChartData> getChartSeries() {
        return this.chartSeries;
    }

    public Map<DataType, Range> getRangeMap() {
        return this.rangeMap;
    }

    public void setRangeMap(Map<DataType, Range> rangeMap) {
        this.rangeMap = rangeMap;
    }

    public Range getRange(DataType dataType) {
        return this.rangeMap.get(dataType);
    }

    @Override
    public void fromXML(Element node) {
    }

    @Override
    public Element toXML() {
        Element node = DocumentHelper.createElement((String)"chart");
        node.addAttribute("reportset", SessionData.get().getReportSet());
        node.addAttribute("dateRange", this.chartOption.getPrimaryDateRange().format("yyyyMMdd"));
        if (this.chartOption.isCompareToPast()) {
            node.addAttribute("comparisonDateRange", this.chartOption.getPrimaryDateRange().format("yyyyMMdd"));
        }
        for (LineChartData each : this.chartSeries) {
            node.add(each.toXML());
        }
        return node;
    }

    protected class LineRenderer
    extends XYLineAndShapeRenderer {
        private static final long serialVersionUID = 1L;
        final int index;
        final boolean withShape;

        public LineRenderer(int index) {
            this.index = index;
            this.withShape = ((LineChartData)LineChart.this.chartSeries.get(index)).size() < 50;
        }

        private boolean hasBuild(int item) {
            Map map = (Map)LineChart.this.itemRowIndexMap.get(this.index);
            Integer i = (Integer)map.get(item);
            if (i == null) {
                return false;
            }
            LineChartData data = (LineChartData)LineChart.this.chartSeries.get(this.index);
            if (i >= data.size()) {
                return false;
            }
            return data.getItem(i).getTotalBuilds() > 0;
        }

        public Paint getItemFillPaint(int series, int item) {
            if (!this.withShape || this.hasBuild(item)) {
                return super.getItemFillPaint(series, item);
            }
            return super.getItemOutlinePaint(series, item);
        }

        public Paint getItemOutlinePaint(int series, int item) {
            if (!this.withShape || this.hasBuild(item)) {
                return super.getItemOutlinePaint(series, item);
            }
            return super.getItemFillPaint(series, item);
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isWithShape() {
            return this.withShape;
        }
    }

    private class StatsToolTipGenerator
    extends StandardXYToolTipGenerator {
        private static final long serialVersionUID = 1L;
        final int index;

        public StatsToolTipGenerator(int index) {
            this.index = index;
        }

        public String generateLabelString(XYDataset dataset, int series, int item) {
            boolean compareToPast;
            boolean hasTooltip;
            int size = dataset.getItemCount(series);
            boolean bl = hasTooltip = size <= 50 || item % (size / 50 + 1) == 0 || item == size - 1;
            if (!hasTooltip) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            boolean bl2 = compareToPast = LineChart.this.chartOption.getCompareOption() == CompareOption.ONE_METRIC && LineChart.this.chartOption.isCompareToPast();
            if (!compareToPast) {
                int rowIndex = (Integer)((Map)LineChart.this.itemRowIndexMap.get(this.index)).get(item);
                LineChartItem chartItem = ((LineChartData)LineChart.this.chartSeries.get(this.index)).getItem(rowIndex);
                switch (LineChart.this.chartOption.getGroupOption()) {
                    case BY_VERSION: {
                        break;
                    }
                    case BY_DAY: {
                        sb.append("<p class='light-text'>").append(chartItem.getDateRange().format("EEEEE MMMMM dd")).append("</p>");
                        break;
                    }
                    default: {
                        sb.append("<p class='light-text'>").append(chartItem.getDateRange().format("MMMMM dd")).append("</p>");
                    }
                }
            }
            for (int i = 0; i < LineChart.this.chartSeries.size(); ++i) {
                LineChartData data = (LineChartData)LineChart.this.chartSeries.get(i);
                sb.append("<div class='chart-tooltip tooltip-").append(i);
                if (i == 0) {
                    sb.append(" first");
                }
                if (i + 1 == LineChart.this.chartSeries.size()) {
                    sb.append(" last");
                }
                sb.append("'>");
                sb.append("<p>");
                Integer rowIndex = (Integer)((Map)LineChart.this.itemRowIndexMap.get(i)).get(item);
                if (rowIndex == null) {
                    sb.append("N/A");
                } else {
                    DateRange range;
                    LineChartItem chartItem = data.getItem(rowIndex);
                    if (compareToPast && (range = chartItem.getDateRange()) != null) {
                        sb.append("<span class='light-text'>").append(range.format("MMM dd, yyyy")).append("</span><br/>");
                    }
                    if (rowIndex >= data.size()) {
                        sb.append(data.getSetting().getTitle()).append(": ").append("<strong>N/A</strong>");
                    } else {
                        sb.append(this.formatToolTip(data, chartItem));
                    }
                }
                sb.append("</p>");
                sb.append("</div>");
            }
            return sb.toString();
        }

        private String formatToolTip(LineChartData data, LineChartItem chartItem) {
            DataType dataType = data.getDataType();
            StringBuffer sb = new StringBuffer();
            sb.append(data.getSetting().getTitle()).append(": <strong>");
            int validBuilds = chartItem.getValidBuilds();
            if (validBuilds == 0) {
                sb.append(dataType.asString(0));
            } else {
                sb.append(dataType.asString(chartItem.getValue()));
            }
            sb.append("</strong> <br/>");
            if (LineChart.this.chartOption.getGroupOption() == GroupOption.BY_VERSION) {
                sb.append("Build: ").append(ReportUtils.hyperlinkBuild(chartItem.getFromBuild()));
            } else {
                BuildFragment from = chartItem.getFromBuild();
                BuildFragment to = chartItem.getToBuild();
                if (from != null) {
                    sb.append(ReportUtils.hyperlinkBuild(from));
                }
                if (to != null && !Objects.equal((Object)from, (Object)to)) {
                    sb.append(" - ").append(ReportUtils.hyperlinkBuild(to));
                }
                if (LineChart.this.showBuildInfo) {
                    sb.append(" <span class='light-text'>(").append(chartItem.getSucceeded()).append(" successed, ").append(chartItem.getFailed()).append(" failed").append(")</span>");
                }
            }
            return sb.toString();
        }
    }

    private class LineGroup {
        private int num = 0;
        private List<Integer> indexes = Lists.newArrayList();
        private NumberAxis axis;
        private int axisIndex;

        private LineGroup() {
        }

        public int getNum() {
            return this.num;
        }

        public void setNum(int num) {
            this.num = num;
        }

        public List<Integer> getIndexes() {
            return this.indexes;
        }

        public NumberAxis getAxis() {
            return this.axis;
        }

        public void setAxis(NumberAxis axis) {
            this.axis = axis;
        }

        public int getAxisIndex() {
            return this.axisIndex;
        }

        public void setAxisIndex(int axisIndex) {
            this.axisIndex = axisIndex;
        }
    }

    private class DomainTickUnit
    extends NumberTickUnit {
        private static final long serialVersionUID = 1L;

        public DomainTickUnit(double size) {
            super(size);
        }

        public String valueToString(double value) {
            return LineChart.this.domainValueToString(value);
        }
    }
}

