/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.aggregation;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.aggregationsupport.Aggregation;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.SqlBuilder;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.web.behavior.RefreshBehavior;
import com.pmease.quickbuild.web.component.LazyLoadPanel;
import com.pmease.quickbuild.web.page.configuration.StatisticsPage;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.template.PackageTextTemplate;
import org.apache.wicket.util.visit.IVisit;

public class DefaultAggregationPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private final AbstractRenderer renderer;
    private WebMarkupContainer container;
    private String toTab;
    private final IModel<List<String>> namesModel;
    static ResourceReference AGGREGATION_JS = new PackageResourceReference(DefaultAggregationPanel.class, "aggregation.js");

    public DefaultAggregationPanel(String id, AbstractRenderer renderer, String toTab) {
        super(id);
        this.renderer = renderer;
        this.toTab = toTab;
        this.namesModel = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 1L;

            protected List<String> load() {
                return DefaultAggregationPanel.this.getValidAggregations();
            }
        };
    }

    public void onInitialize() {
        super.onInitialize();
        this.container = new WebMarkupContainer("container"){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void renderHead(IHeaderResponse response) {
                super.renderHead(response);
                PackageTextTemplate template = new PackageTextTemplate(DefaultAggregationPanel.class, "aggregation.js");
                try {
                    HashMap map = Maps.newHashMap();
                    map.put("container", DefaultAggregationPanel.this.container.getMarkupId(true));
                    String s = template.asString((Map)map);
                    response.renderOnDomReadyJavaScript(s);
                }
                finally {
                    IOUtils.closeQuietly((Closeable)template);
                }
            }
        };
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        List<String> names = this.getAggregationNames();
        this.setVisible(names.size() > 0);
        if (names.size() > 0) {
            BookmarkablePageLink link = new BookmarkablePageLink("titleLink", StatisticsPage.class, StatisticsPage.params4((Long)Context.getConfiguration().getId(), (String[])new String[]{this.toTab}));
            this.container.add(new Component[]{link});
            link.add(new Component[]{new Label("title", this.getRenderer().getTitle())});
            link.setEnabled(!Strings.isNullOrEmpty((String)this.toTab));
            this.container.add(new Component[]{new AjaxLink<Void>("refreshLink"){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    Component c = DefaultAggregationPanel.this.createContent();
                    DefaultAggregationPanel.this.container.addOrReplace(new Component[]{c});
                    target.add(new Component[]{c});
                }
            }});
            this.container.add(new Component[]{this.createContent()});
            this.container.add(new Behavior[]{new RefreshBehavior(){
                private static final long serialVersionUID = 1L;

                public boolean needRefresh(IVisit<Void> visit, Date lastRefreshDate) {
                    ReportCategory category = DefaultAggregationPanel.this.getRenderer().getCategory();
                    File dbDir = category.getCategoryDirOfAggregation(Context.getConfiguration());
                    if (!dbDir.exists()) {
                        return false;
                    }
                    List<String> names = DefaultAggregationPanel.this.getAggregationNames();
                    for (String each : names) {
                        File reportDir = category.getReportDirOfAggregation(Context.getConfiguration(), each);
                        CategoryDb db = category.getCategoryDb(reportDir);
                        File file = db.getDbFile();
                        if (!file.exists() || file.lastModified() <= lastRefreshDate.getTime()) continue;
                        return true;
                    }
                    return false;
                }
            }});
        }
    }

    Component createContent() {
        return new LazyLoadPanel("content"){
            private static final long serialVersionUID = 1L;

            public Component getLazyLoadComponent(String markupId) {
                Fragment fragment = new Fragment(markupId, "sections", (MarkupContainer)DefaultAggregationPanel.this);
                fragment.add(new Component[]{new AggregationViewer("repeater", DefaultAggregationPanel.this.getAggregationNames())});
                return fragment;
            }
        };
    }

    protected List<String> getAggregationNames() {
        return (List)this.namesModel.getObject();
    }

    protected List<String> getValidAggregations() {
        Configuration configuration = Context.getConfiguration();
        List aggregations = configuration.findAggregations();
        ArrayList names = Lists.newArrayList();
        for (Aggregation each : aggregations) {
            if (!each.isEnabled() || !this.isReportSetApplicable(each.getName())) continue;
            names.add(each.getName());
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isReportSetApplicable(String reportset) {
        ReportCategory category = this.getRenderer().getCategory();
        File dir = category.getReportDirOfAggregation(Context.getConfiguration(), reportset);
        if (!dir.exists()) {
            return false;
        }
        CategoryDb db = category.getCategoryDb(dir);
        SqlBuilder query = SqlBuilder.query().select("count(*)").from(this.getRenderer().getReportName());
        try {
            db.open(DbStore.Mode.READ_ONLY, "DefaultAggregationPanel::isReportSetApplicable");
            Long count = db.queryForLong(query);
            boolean bl = count > 0L;
            return bl;
        }
        finally {
            db.close();
        }
    }

    public AbstractRenderer getRenderer() {
        return this.renderer;
    }

    public void onDetach() {
        super.onDetach();
        if (this.namesModel != null) {
            this.namesModel.detach();
        }
    }

    class AggregationViewer
    extends ListView<String> {
        private static final long serialVersionUID = 1L;

        public AggregationViewer(String id, List<? extends String> list) {
            super(id, list);
        }

        protected void populateItem(ListItem<String> item) {
            String reportset = (String)item.getModelObject();
            Component label = new Label("reportset", reportset).setVisible(this.getList().size() > 1);
            item.add(new Component[]{label.setOutputMarkupId(true)});
            AbstractRenderer renderer = DefaultAggregationPanel.this.getRenderer();
            renderer.setIgnoreSessionFilter(true);
            RendererContext rc = new RendererContext();
            rc.setReportSet(reportset);
            item.add(new Component[]{renderer.createReportPanel("content", (IModel<RendererContext>)Model.of((Serializable)rc))});
        }
    }
}

