/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.aggregation;

import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableReportPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.datagrid.DataGrid;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.datagrid.RowGroupDataGrid;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.toolbar.SearchNavToolbar;
import java.io.File;
import org.apache.wicket.model.IModel;

public class AggregationTablePanel
extends TableReportPanel {
    private static final long serialVersionUID = 1L;

    public AggregationTablePanel(String id, TableRenderer renderer, IModel<RendererContext> model) {
        super(id, renderer, model);
    }

    @Override
    public void onInitialize() {
        super.onInitialize();
    }

    protected Long getLastUpdatedDate() {
        ReportCategory category = this.getRenderer().getCategory();
        File dbDir = this.getDbDir();
        if (!dbDir.exists()) {
            return null;
        }
        CategoryDb db = category.getCategoryDb(dbDir);
        File file = db.getDbFile();
        if (!file.exists()) {
            return null;
        }
        return file.lastModified();
    }

    @Override
    protected DataGrid newDataGrid(String id) {
        return new RowGroupDataGrid(id, this.getColumns(), this.provider, this);
    }

    @Override
    protected void addToolbars(final DataGrid dataGrid) {
        super.addToolbars(dataGrid);
        dataGrid.addBottomToolbar(new SearchNavToolbar(dataGrid, ""){
            private static final long serialVersionUID = 1L;

            @Override
            public void onConfigure() {
                super.onConfigure();
                this.setVisibilityAllowed(dataGrid.getRowCount() > AggregationTablePanel.this.getRenderer().getRowsPerPage());
            }

            @Override
            protected boolean isShowSearchForm() {
                return false;
            }
        });
    }

    @Override
    public File getDbDir() {
        return this.getRenderer().getCategory().getReportDirOfAggregation(this.getConfiguration(), this.getReportSet());
    }
}

